<?php

namespace App\Http\Controllers;

use App\Models\Category;
use Illuminate\Http\Request;

class CategoryController extends Controller
{


    public function store(Request $request){
        $category = new Category();
        $category->name = $request->name;
        $category->icon = $request->icon;

        if($category->save()){
            return response('ok', 200);
        }
        return response('error', 200);
    }

    /**
     * 
     */
    public function update(Request $request){
        $category = Category::findOrFail($request->id);
        $category->name = $request->name;
        $category->icon = $request->icon;

        if($category->update()){
            return response('ok', 200);
        }
        return response('error', 200);
    }

    /**
     * 
     */
    public function delete($id){
        $category = Category::findOrFail($id);
        $category->delete();
    }
}
