<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;
use App\Models\Certificates;
use App\Models\UserConfiguration;
use App\Models\Course;
use App\Models\User;
use App\Models\UserCertificate;
use App\Http\Controllers\BadgeController;
use Illuminate\Support\Facades\Storage;
use App\Models\CourseConfiguration;
use App\Models\PurchasedCourse;

class CertificatesController extends Controller
{
    public function index()
    {
        return view('content.config.certificates-config');
    }

    public function showAll()
    {
        $user = auth()->user();
        //signature
        $signature = UserConfiguration::where(
            ['configuration_id' => 2, 'user_id' => $user->id]
        )->get(); //template
        $templateUserConfig = UserConfiguration::where(
            ['configuration_id' => 1, 'user_id' => $user->id]
        )->get();

        $certificates = Certificates::get();

        $data = [$certificates, $signature, $templateUserConfig];

        return JsonResource::collection($data);
    }
    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function addCertificate(Request $request)
    {

        $cambioImagen = $request->hasFile('signature') ? 0 : 1;
        $id = $request->id;
        $user = auth()->user();

        $signature = UserConfiguration::where(
            ['configuration_id' => 2, 'user_id' => $user->id]
        )->get();

        if (count($signature) != 0 || $cambioImagen == 0) {
            if (is_null($id)) {
                $certificate = new Certificates();
                $certificate->name = $request->name;
                $certificate->template = $request->template;
                $certificate->id_user = auth()->user()->id;
                $certificate->save();
                if ($cambioImagen == 1) {
                    return response('ok', 200);
                }
            } elseif (!is_null($id)) {
                $certificate = Certificates::find($request->id);
                $certificate->name = $request->name;
                $certificate->template = $request->template;
                $certificate->save();
                if ($cambioImagen == 1) {
                    return response('ok', 200);
                }
            }
            if ($cambioImagen == 0) {
                //$nameImg = time() . '_' . $request->file('signature')->getClientOriginalName();
                $nameImg = $this->saveSignatureS3($user, $request);

                UserConfiguration::updateOrCreate(
                    ['user_id' => $user->id, 'configuration_id' => 2],
                    [
                        'value' => $nameImg,
                    ]
                );
                //$request->file('signature')->storeAs('certificates/signatures', $nameImg);
                return response('ok', 200);
            } else {
                return response('error ', 200);
            }
        } else {
            return response('error_img', 200);
        }
    }
    public function saveSignatureS3($user, $request)
    {
        //no se va eliminara la firma anterior, porque se esta utilizando en algun certificado html
        $path_photo = 'user_photos/' . $user->id;
        $name_photo = $request->file('signature')->getClientOriginalName();

        Storage::disk('s3')->putFileAs($path_photo, $request->file('signature'), $name_photo,  'public');
        $nameImg = $path_photo . '/' . $name_photo;
        return $nameImg;
    }
    public function destroyCertificate($id)
    {

        $certificate = Certificates::find($id);
        if ($certificate->delete()) {
            return response('ok', 200);
        } else {
            return response('error', 200);
        }
    }
    public function saveConfigCertificate(Request $request)
    {

        $validateImagen = $request->hasFile('signature') ? 0 : 1;
        $user = auth()->user();
        //si existe imagen y plantilla
        if ($validateImagen == 0 && $request->id != -1) {

            $nameImg = $this->saveSignatureS3($user, $request);

            UserConfiguration::updateOrCreate(
                ['user_id' => $user->id, 'configuration_id' => 1],
                [
                    'value' => $request->id,
                ]
            );
            UserConfiguration::updateOrCreate(
                ['user_id' => $user->id, 'configuration_id' => 2],
                [
                    'value' => $nameImg,
                ]
            );

            return response('ok', 200);
        } //si no hay imagen -  si solo hay plantilla
        else if ($validateImagen == 1) {
            UserConfiguration::updateOrCreate(
                ['user_id' => $user->id, 'configuration_id' => 1],
                [
                    'value' => $request->id,
                ]
            );
            return response('ok', 200);
        } //si solo hay imagen
        else if ($request->id == -1) {

            $nameImg = $this->saveSignatureS3($user, $request);

            UserConfiguration::updateOrCreate(
                ['user_id' => $user->id, 'configuration_id' => 2],
                [
                    'value' => $nameImg,
                ]
            );

            return response('ok', 200);
        } else {
            return response('error', 200);
        }
    }
    
    public function getCertificateUser($course_id)
    {

        $user = auth()->user();
        $is_paid = UserCertificate::where(['id_user' => $user->id, 'id_course' =>  $course_id, 'is_paid' => 1])->exists();
        $Certificate = PurchasedCourse::where('user_id', $user->id)
            ->where('course_id', $course_id)
            ->first();
        $Certificate->certificate_path = config('global_variables.storage_domain').'/'.$Certificate->certificate_url;
        $data = [
            "Certificate" => $Certificate,
            'is_paid' => $is_paid
        ];
        return response($data, 200);
    }

    public function getCertificateUserList()
    {

        $user = auth()->user();
        $Certificate = UserCertificate::select('courses.title', 'user_certificates.id AS user_certificate_id', 'courses.id', 'courses.portada', 'courses.url_portada','user_certificates.is_paid','course_configuration.data')
            ->join('courses', 'courses.id', '=', 'user_certificates.id_course')
            ->join('course_configuration', 'user_certificates.id_course', '=', 'course_configuration.course_id')
            ->where(['user_certificates.id_user' => $user->id])
            ->distinct('courses.id')
            ->get();

        $congratulation = false;
        $congratulation_certificate_url = "";
        foreach ($Certificate as $cert) {
            $cert->url_portada = config('global_variables.storage_domain') . '/' . $cert->url_portada;
            $congratulation_pending = PurchasedCourse::where('course_id', $cert->id)
                ->where('completed_course', 1)
                ->where('certificate_delivered', 1)
                ->where('certificate_seen', 0)
                ->where('user_id', $user->id)
                ->exists();
            if($congratulation_pending){
                $congratulation = true;
                $congratulation_certificate_url = PurchasedCourse::where('course_id', $cert->id)
                    ->where('completed_course', 1)
                    ->where('certificate_delivered', 1)
                    ->where('certificate_seen', 0)
                    ->where('user_id', $user->id)
                    ->first()
                    ->certificate_url;
                $congratulation_certificate_url = config('global_variables.storage_domain').$congratulation_certificate_url;
            }
        }
        $data = [
            'Certificate' => $Certificate,
            'congratulation' => $congratulation,
            'congratulation_certificate_url' => $congratulation_certificate_url
        ];
        return response($data, 200);
    }

    public function createCertificate($user, $course_id)
    {
        //$user = auth()->user();
        $course = Course::find($course_id);
        //$course = Course::find($request->course_id);//get id_user_productor
        $plantillaProductor = UserConfiguration::select('id', 'value')
            ->where(['user_id' => $course->user_id, 'configuration_id' => 1])
            ->first();
        //al parecer el error es q no se configura adecuadamente el id del productor en la tabla
        $signatureProductor = UserConfiguration::select('id', 'value',)
            ->where(['user_id' => $course->user_id, 'configuration_id' => 2])
            ->first();
        //id creador del la plantilla (admin)
        $certificate = Certificates::find($plantillaProductor->value);
        $user_productor = User::find($course->user_id);
        //Admin creador de la plantilla, info
        $user_admin = User::find($certificate->id_user);
        $signatureAdmin = UserConfiguration::select('id', 'value',)
            ->where(['user_id' => $certificate->id_user, 'configuration_id' => 2])
            ->first();

        //reemplazar
        $resultado = str_replace("@usuario", ($user->name . " " . $user->last_name), $certificate->template);
        $resultado = str_replace("@curso", $course->title, $resultado);
        //Admin
        $img_admin = '<img crossorigin="anonymous" class="signatureImg"  src="https://promolider-storage-user.s3-accelerate.amazonaws.com/' . ($signatureAdmin->value) . '"height="50px"/>';
        $resultado = str_replace("@firma_administrador", $img_admin, $resultado);
        $resultado = str_replace("@administrador", $user_admin->name, $resultado);
        
        $img = '<img crossorigin="anonymous" class="signatureImg" src="https://promolider-storage-user.s3-accelerate.amazonaws.com/' . ($signatureProductor->value) . '"height="50px"/>';
        $resultado = str_replace("@firma_productor", $img, $resultado);
        $resultado = str_replace("@productor", $user_productor->name, $resultado);

        $this->screenshot($course_id, $user);
        // UserCertificate

        $courseConfig = CourseConfiguration::where('course_id',$course_id)->get()->first();
        $isPaid=1;
        if($courseConfig->type_certificate == 0){
            $isPaid=0;
        } 

        UserCertificate::updateOrCreate(
            ['id_user' => $user->id, 'id_course' => $course_id],
            [
                'certificate' => $resultado,
                'is_paid' => $isPaid
            ]
        );
        //CREAR INSIGNIA
        app(BadgeController::class)->validateBadgesCertificates($user->id);

        return $resultado;
    }

    public function screenshot($course_id, $user){
        $verify = PurchasedCourse::where([
                "course_id" => $course_id,
                "user_id" => $user->id,
                "completed_course" => 1
            ])
            ->exists();
        if($verify){
            $purchased = PurchasedCourse::where([
                    "course_id" => $course_id,
                    "user_id" => $user->id,
                ])->first();
            $course_id = 4;
            $user = User::findOrFail(auth()->user()->id);
            $token = env('ACCESS_CONVERSOR');
            // $url = urlencode("http://crm.promolider.info/get-certificado?course_id=$course_id&user_id=$user->id");
            $url = urlencode("http://crm.promolider.info/get-certificado?course_id=$course_id");
            $width = 1100;
            $height = 580;
            $delay = 10000;
            $output = 'image';
    
            $query = "https://shot.screenshotapi.net/screenshot";
            $query .= "?token=$token&url=$url&width=$width&height=$height&output=$output&delay=$delay";
            $date = date("YmdHis_");
            $path = 'certificates/';
            $name = $date.$course_id.$user->id;
            Storage::disk('s3')->put($path . $name, file_get_contents($query), 'public');

            $purchased->certificate_url = $path.$name;
            $purchased->update();
        }
    }

    public function getCertificado(Request $request){
        $user = User::findOrFail(auth()->user()->id);
        $verify = PurchasedCourse::where([
                "course_id" => $request->course_id,
                "user_id" => $user->id,
                "completed_course" => 1
            ])
            ->exists();
        if($verify){
            $course = Course::find($request->course_id);
            //$course = Course::find($request->course_id);//get id_user_productor
            $plantillaProductor = UserConfiguration::select('id', 'value')
                ->where(['user_id' => $course->user_id, 'configuration_id' => 1])
                ->first();
            //al parecer el error es q no se configura adecuadamente el id del productor en la tabla
            $signatureProductor = UserConfiguration::select('id', 'value',)
                ->where(['user_id' => $course->user_id, 'configuration_id' => 2])
                ->first();
            //id creador del la plantilla (admin)
            $certificate = Certificates::find($plantillaProductor->value);
            $user_productor = User::find($course->user_id);
            //Admin creador de la plantilla, info
            $user_admin = User::find($certificate->id_user);
            $signatureAdmin = UserConfiguration::select('id', 'value',)
                ->where(['user_id' => $certificate->id_user, 'configuration_id' => 2])
                ->first();
    
            $img_admin = '<img crossorigin="anonymous" class="signatureImg"  src="https://promolider-storage-user.s3-accelerate.amazonaws.com/' . ($signatureAdmin->value) . '"height="50px"/>';
            $img = '<img crossorigin="anonymous" class="signatureImg" src="https://promolider-storage-user.s3-accelerate.amazonaws.com/' . ($signatureProductor->value) . '"height="50px"/>';
    
            $usuario = $user->name . " " . $user->last_name;
            $curso = $course->title;
            $firma_administrador = $img_admin;
            $administrador = $user_admin->name;
            $firma_productor = $img;
            $productor = $user_productor->name;
    
            return view('content.certificado', compact('usuario', 'curso', 'firma_administrador', 'administrador', 'firma_productor', 'productor'));
        }
    }
}
