<?php

namespace App\Http\Controllers;

use App\Models\Chat;
use App\Models\ChatDetail;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;
use Spatie\PdfToText\Pdf;

class ChatGptController extends Controller
{
    public function index()
    {
        $user_id = auth()->user()->id;
        return view('content.chatgpt.index', compact('user_id'));
    }

    public function getChat($id)
    {
        $chats = Chat::where('user_id', $id)->get();
        return response()->json([
            'status' => true,
            'data' => $chats,
            'message' => 'Data recuperada con exito'
        ], 200);
        
    }

    public function chat(Request $request)
    {
        $levelCourse = "";
        $prom = $request->input('prom');
        
        if ($request->input('level') == 1) {
            $levelCourse = "Curso básico con 2 módulos, un precio acorde a la cantidad de módulos.";
        } else if ($request->input('level') == 2) {
            $levelCourse = "Curso Intermedio con 4 módulos, un precio acorde a la cantidad de módulos.";
        } else {
            $levelCourse = "Curso Avanzado con 6 módulos, un precio acorde a la cantidad de módulos.";
        }

        $prompt = $request->input('queryResult');

        $concat = "Genera el curso " . $prompt . " Título general:, Descripción:, Precio:, Acerca del curso:, Lo que aprenderá:, 
        Conocimientos previos:, Curso destinado para:, Esquemas del curso:, Cada uno de estos puntos en párrafos diferentes en Esquemas del curso
        genera Módulos y título del módulo y sus subtemas." . $levelCourse . "
        Siempre inicia mostrando Título general y termina en módulos No agregues más texto después de esto.";

        $textConcat = $prom == 1 ? $prompt : $concat;
        
        $response = $this->envia($textConcat);
        $responseText = $response['choices'][0]['message']['content'];

        $linesToBold = ['Título general:', 'Descripción:', 'Precio:', 'Acerca del curso:', 'Lo que aprenderá:', 'Conocimientos previos:', 'Curso destinado para:', 'Esquemas del curso:'];

        foreach ($linesToBold as $line) {
            if (strpos($responseText, $line) !== false) {
                $responseText = str_replace($line, '<h3>' . $line . '</h3>', $responseText);
            }
        }
        
        if (strpos($responseText, 'Módulo') !== false) {
            $pattern = '/Módulo[^\n]*/';
            $responseText = preg_replace($pattern, '<h4>$0</h4>', $responseText);
        }
        
        return response()->json([
            'response' => $responseText, 
        ]);
        
    }

    public function envia($param)
    {
        try {
            $messages = [
                [
                    "role" => "user",
                    "content" => $param
                ]
            ];
            $apiKey = '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';

            $data = [
                "model" => "gpt-3.5-turbo",
                'messages' => $messages,
                'temperature' => 0.7,
                'max_tokens' => 700,
                'n' => 1,
                'stop' => ['\n']
            ];
    
            $ch = curl_init('https://api.openai.com/v1/chat/completions');
            curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "POST");
            curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_HTTPHEADER, array(
                'Content-Type: application/json',
                'Authorization: Bearer ' . $apiKey
            ));
        
            $response = curl_exec($ch);
            $responseArr = json_decode($response, true);

            if (isset($responseArr['choices']) && is_array($responseArr['choices']) && count($responseArr['choices']) > 0) {
                $data = $responseArr;
            } else {
                $data = $responseArr;
            }

            return $data;

        } catch (\Throwable $th) {
            // Registrar el error
            Log::info("Ocurrió un error al consultar", [$th->getMessage()]);
        }
    }

    public function store(Request $request)
    {
        try {
            DB::beginTransaction();
            $chat = new Chat();
            $chat->title = $request->ask;
            $chat->user_id = auth()->user()->id;
            $chat->save();

            $chatDetails = new ChatDetail();
            $chatDetails->ask = $request->ask;
            $chatDetails->answer = json_encode($request->answer);
            $chatDetails->chat_id = $chat->id;
            $chatDetails->save();

            DB::commit();

            return response()->json([
                'status' => true,
                'data' => $chat,
                'message' => 'Registro exitoso'
            ], 200);

        } catch (\Throwable $th) {
            DB::rollBack();
            return response()->json([
                'status' => false,
                'message' => 'Ocurrio un error ' . $th->getMessage()
            ], 500);
        }
    }

    public function show($id)
    {
        $chat = Chat::with('details')->findOrFail($id);

        return response()->json([
            'data' => $chat,
            'messaga' => 'Data generada'
        ], 200);
    }

    public function subirPDF(Request $request){ 
        try {
            // Obtener el archivo PDF del request
            $archivo = $request->file('pdf');
    
            // Verificar si se ha enviado un archivo
            if($archivo){ 
                // Obtener la extensión del archivo
                $ext = $archivo->extension();
    
                // Generar un nombre único para el archivo
                $hoy = date('YmdHis');
                $nombreArchivo = "course_$hoy.$ext";
    
                // Almacenar el archivo en el sistema de archivos
                $archivo->storeAs('courses',$nombreArchivo);
    
                // Ruta del archivo PDF almacenado
                // En windows : str_replace('/', '\\', storage_path("app/public/courses/$nombreArchivo"));
                // En producción y en desarrollo: 
                $pdfFilePath = storage_path("app/public/courses" . DIRECTORY_SEPARATOR . $nombreArchivo);

                if (file_exists($pdfFilePath)) {
                    // Extraer el texto del PDF utilizando la biblioteca Pdf

                    # Cambiar en entorno de producción a /usr/bin/pdftotext (por defecto)
                    # Cambiar en entorno de desarrollo a C:\laragon\bin\git\mingw64\bin\pdftotext
                    # para mas info de la biblioteca: https://github.com/spatie/pdf-to-text
                    $extractedText = Pdf::getText($pdfFilePath);

                    $extractedText = mb_convert_encoding($extractedText, 'UTF-8', 'UTF-8');
                    
                    $levelCourse = "";
                    $prom = $request->input('prom');
                    
                    if ($request->input('level') == 1) {
                        $levelCourse = "Curso básico con 2 módulos, un precio acorde a la cantidad de módulos.";
                    } else if ($request->input('level') == 2) {
                        $levelCourse = "Curso Intermedio con 4 módulos, un precio acorde a la cantidad de módulos.";
                    } else {
                        $levelCourse = "Curso Avanzado con 6 módulos, un precio acorde a la cantidad de módulos.";
                    }

                    $concat = "A partir de este texto: \n\n". $extractedText ."\n\nGenera el curso con los siguientes parámetros: Título general:, Descripción:, Precio:, Acerca del curso:, Lo que aprenderá:, 
                    Conocimientos previos:, Curso destinado para:, Esquemas del curso:, Cada uno de estos puntos en párrafos diferentes en Esquemas del curso
                    genera Módulos y título del módulo y sus subtemas." . $levelCourse . 
                    "\nSiempre inicia mostrando Título general y termina en módulos No agregues más texto después de esto.";

                    $textConcat = $prom == 1 ? $prompt : $concat;

                    $response = $this->envia($textConcat);
                    
                    $responseText = $response['choices'][0]['message']['content'];
                    
                    $linesToBold = ['Título general:', 'Descripción:', 'Precio:', 'Acerca del curso:', 'Lo que aprenderá:', 'Conocimientos previos:', 'Curso destinado para:', 'Esquemas del curso:'];

                    foreach ($linesToBold as $line) {
                        if (strpos($responseText, $line) !== false) {
                            $responseText = str_replace($line, '<h3>' . $line . '</h3>', $responseText);
                        }
                    }
                    if (strpos($responseText, 'Módulo') !== false) {
                        $pattern = '/Módulo[^\n]*/';
                        $responseText = preg_replace($pattern, '<h4>$0</h4>', $responseText);
                    }
                    return response()->json([
                        'status'=>True,
                        'data'=>$responseText,
                        'mensaje' => 'Chat PDF Activo'
                    ],200);
                } else {
                    return response()->json([
                        'mensaje' => "El archivo PDF no existe en la ruta especificada."
                    ], 404);
                }
            } else {
                // Si no se ha enviado ningún archivo, retornar un mensaje de error
                return response()->json([
                    'mensaje'=>"No se ha enviado ningún archivo PDF"
                ], 400);
            }
        } catch (\Exception $e) {
            // Manejar excepciones
            Log::error($e->getMessage());
            return response()->json([
                'mensaje'=>"Error al procesar el archivo PDF: " . $e->getMessage()
            ], 500);
        }
    }    
}
