<?php

namespace App\Http\Controllers\MC;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\MasterClassNotification;
use App\Models\User;
use Illuminate\Support\Facades\DB;


class NotificationController extends Controller
{
    public function list()
    {
        $userId = auth()->user()->id;
        $notifications = MasterClassNotification::where('receiver', $userId)->get();
        
        return response()->json($notifications, 200);
    }

    public function markAsSeen($id)
    {
        $notification = MasterClassNotification::where('id', $id)->first();
        $notification->seen = true;
        $notification->save();
        return response()->json(['message' => 'Notificación marcada como leída'], 200);
    }
}
