<?php

namespace App\Http\Controllers;

use Carbon\Carbon;
use App\Models\User;
use App\Helpers\Encryptor;
use App\Models\SponsorLink;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;

use function PHPUnit\Framework\isNull;
use App\Http\Resources\SponsorLinkResource;
use Illuminate\Http\Resources\Json\JsonResource;

class ShareLinkController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        return view('content.config.share-link');
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function Add(Request $request)
    {
        DB::statement('CALL delete_expired_records_procedure()');

        $userTimezone = auth()->user()->timezone;

        $userDate = Carbon::now($userTimezone);

        $sponsorLink = new SponsorLink();
        $sponsorLink->user_id = $request->user_id;
        $sponsorLink->url = $request->url .'/'. time();
        $sponsorLink->estado = $request->estado;
        $sponsorLink->fecha_inicio = $userDate;
        $sponsorLink->fecha_fin = $userDate->copy()->addMinutes(15);
        $result = new SponsorLinkResource($sponsorLink);

        if ($sponsorLink->save()) :
            return ($result)->response()->setStatusCode(200);
        endif;

        return $result->response()->setStatusCode(400);
    }

    public function Delete($id)
    {
        $shareLink = SponsorLink::findOrFail($id);

        if ($shareLink == null) {
            return response()->json([
                'success' => false,
                'message' => 'Ocurrio un error al ejecutar la operación',
                'state' => 404
            ], 404);
        }

        if ($shareLink->delete()) {
            return response()->json([
                'success' => true,
                'message' => 'Registro eliminado con exito',
                'state' => 200
            ], 200);
        };

        return response()->json([
            'success' => false,
            'message' => 'Ocurrio un error',
            'state' => 400
        ], 400);
    }

    public function retornarVista($username)
    {
        $user = User::where('username', $username)->first();
        $link = SponsorLink::where('user_id', $user->id)->first();
        if(is_null($link) || Carbon::now()->gt($link->fecha_fin)){
            $link = 0;
        }
        $this->authorize('view', $user);
        return response()->json([$user, $link], 200);
    }
}
