<?php

namespace App\Http\Controllers;

use App\Models\Transaction;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Log;

class TransactionController extends Controller
{

    public function index()
    {
    }

    public function createTransaction($request)
    {
        try {
            $dataServer = $request;
            $transaction = new Transaction();

            $transaction->operation_number = $dataServer['id'];
            $transaction->authorization = $dataServer['authorization'];
            $transaction->operation_type = $dataServer['operation_type'];
            $transaction->transaction_type = $dataServer['transaction_type'];
            $transaction->status = $dataServer['status'];
            $transaction->conciliated = $dataServer['conciliated'];

            //Formateando la fecha antes de guardarla en BD
            $creationDate = \Carbon\Carbon::parse($dataServer['creation_date']);
            $transaction->creation_date = $creationDate;

            $operationDate = \Carbon\Carbon::parse($dataServer['operation_date']);
            $transaction->operation_date = $operationDate;

            $transaction->description = $dataServer['description'];
            $transaction->error_message = $dataServer['error_message'];
            $transaction->order_id = $dataServer['order_id'];
            $transaction->card = json_encode($dataServer['card']);

            $dueDate = \Carbon\Carbon::parse($dataServer['due_date']);
            
            $transaction->due_date = $dueDate;

            $transaction->amount = $dataServer['amount'];
            $transaction->customer = json_encode($dataServer['customer']);
            $transaction->fee = json_encode($dataServer['fee']);
            $transaction->payment_method = json_encode($dataServer['payment_method']);
            $transaction->metadata = json_encode($dataServer['metadata']);
            $transaction->currency = $dataServer['currency'];
            $transaction->method = $dataServer['method'];
            //Log::info('Antes de guardar la transacción en la base de datos');
            $transaction->save();
            //Log::info('Transacción guardada exitosamente en la base de datos');

            
        } catch (\Exception $e) {
            Log::error('Error al procesar la transaccion', ['error_message' => $e->getMessage()]);
        }
    }
}
