<?php namespace App\Services;

use App\Helpers\ParseUrl;
use App\Models\Notifications;

class NotificationService 
{
    public function myNotification()
    {
        $user_id = auth()->user()->id;
        $notifications = Notifications::join('users','users.id','=','id_generator')->where('id_receiver',$user_id)
        ->where('seen',0)->select('users.photo','title','body')->take(3)->get();
        
        for($i = 0; $i < sizeof($notifications); $i++){
            $notifications[$i]->photo = ParseUrl::contacAtrrS3($notifications[$i]->photo);
        }
        return $notifications;
    }

    public function countNotification(){
        $user_id = auth()->user()->id;
        $number = Notifications::where('id_receiver',$user_id)
        ->where('seen',0)->count();

        return $number;
    }

    public function notificationSeen(){
        $user_id = auth()->user()->id;
        $notifications = Notifications::join('users','users.id','=','id_generator')->where('id_receiver',$user_id)
        ->where('seen',1)->select('users.photo','title','body')->take(3)->get();
        for($i = 0; $i < sizeof($notifications); $i++){
            $notifications[$i]->photo = ParseUrl::contacAtrrS3($notifications[$i]->photo);
        }
        return $notifications;
    }

}
