<?php

namespace App\Http\Controllers;

use App\Models\Option;
use App\Models\OpenpayOrder;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Http\Requests\StoreOptionRequest;
use Illuminate\Support\Facades\Log;

class OptionController extends Controller
{
    public function index()
    {
        //
    }

    public function create()
    {
        //
    }

    public function store(StoreOptionRequest $request)
    {
        //
    }

    public function show()
    {
        $options = DB::table('options')->get();
        return view('content.config.config-option')->with('options', $options);
    }

    public function values()
    {
        $options = DB::table('options')->get();
        return  $options;
    }

    public function edit(Option $option)
    {
        //
    }

    public function update(Request $request)
    {
        if ($request->v1 == 1) {
            $this->updateOptions('default_avatar', $request->default_avatar);
        }

        if ($request->v2 == 1) {
            $this->updateOptions('daily_question', $request->daily_question);
        }

        if ($request->v3 == 1) {
            $this->updateOptions('achievement', $request->achievement);
        }

        if ($request->v4 == 1) {
            $this->updateOptions('badges_level_one', $request->badges_level_one);
        }

        if ($request->v5 == 1) {
            $this->updateOptions('badges_level_two', $request->badges_level_two);
        }

        if ($request->v6 == 1) {
            $this->updateOptions('badges_level_three', $request->badges_level_three);
        }
        if ($request->v7 == 1) {
            $this->updateOptions('currency_value', $request->money_points);
        }
    }

    public function updateOptions($description, $value)
    {

        try {
            DB::beginTransaction();

            $course = Option::where('description', $description)->get()->first();
            $course->value = $value;

            if ($course->update()) {
                $response['status'] = 'ok';
            } else {
                $response['status']  = 'error';
            }
            echo json_encode($response);
            DB::commit();
        } catch (\Throwable $th) {
            DB::rollBack();
            throw $th;
        }
    }

    public function openpayOrder()
    {

        $order = OpenpayOrder::first();
        $openpay_order = (int)$order->value;
        $new_order = $openpay_order + 1;
        $order->value = $new_order;
        $order->update();
        Log::info($openpay_order);
        return $openpay_order;
    }
}
