<?php

namespace App\Http\Controllers;

use App\Models\Option;
use Illuminate\Http\Request;
use App\Models\Wallet;
use App\Models\Notifications;
use App\Models\User;
use App\Models\WalletMovements;
use Illuminate\Http\Resources\Json\JsonResource;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Storage;
use App\Helpers\Helper;

class WalletMovementsController extends Controller
{

    public function __construct()
    {
        $this->middleware('can:report-wallets');
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */

    public function getAllMovementsWallet($user_id)
    {
        $myWallet = Wallet::where('user_id', $user_id)->first();
        $user = auth()->user();
        $myMovements = WalletMovements::where('wallet_id', $myWallet->id)->orWhere('id_receiver', $user->id)->get();
        return JsonResource::collection($myMovements);
    }

    public function getAllMovementsHistoryWallet(){
        $allWallets = WalletMovements::where('status', 1)->select('created_at', 'amount', 'reason','type')->get();
        return $allWallets;
    }

    public function transferFounds(Request $request)
    {
        $direct = $request->direct;
        $amount = $request->amount;
        $user = auth()->user();

        $wallet  = Wallet::where('user_id', $user->id)->first();
        $myDirect = User::where('id', $direct)->first();

        $last_batch = Option::lastBatch();
        $last_batch = (int) $last_batch->value;

        try {
            DB::beginTransaction();
            $movement = new WalletMovements();
            $movement->wallet_id = $wallet->id;
            $movement->amount = $amount;
            $movement->type = 0;
            $movement->batch = $last_batch;
            $movement->id_receiver = $myDirect->id;
            $movement->reason = 'Transfer of funds from ' . $user->username . ' to ' . $myDirect->username;

            if ($movement->save()) {
                $response['status'] = 'ok';
            } else {
                $response['status']  = 'error';
            }
            
            DB::commit();

            return response()->json([
                'data' => $response,
                'message' => 'Operación exitosa',
            ], 200);
            
        } catch (\Throwable $th) {
            DB::rollBack();
            throw $th;
        }
    }

    public function requestFounds(Request $request)
    {
        $amount = $request->amount;
        $user = auth()->user();
        $admin = User::where('username',"admin")->first();
        
        $myWallet = Wallet::where('user_id', $user->id)->first();

        $last_batch = Option::lastBatch();
        $last_batch = (int) $last_batch->value;

        try {
            DB::beginTransaction();
            $movement = new WalletMovements();
            $movement->wallet_id = $myWallet->id;
            $movement->amount = $amount;
            $movement->type = 0;
            $movement->batch = $last_batch;
            $movement->status = 0;
            $movement->reason = 'Solicitud de fondos';
            
            if ($movement->save()) {
                $response['status'] = 'ok';
            } else {
                $response['status']  = 'error';
            }
            
            $notification = new Notifications();
            $notification->id_generator = $user->id;
            $notification->id_receiver = $admin->id;
            $notification->title = "Solicitud de Fondos";
            $notification->body = $user->name . " solicita el retiro de $ " . $amount ;
            $notification->type = 1;
            
            if ($notification->save()) {
                $response['status'] = 'ok';
            } else {
                $response['status']  = 'error';
            }
            
            DB::commit();

            return response()->json([
                'data' => $response,
                'message' => 'Operación exitosa',
            ], 200);
            
        } catch (\Throwable $th) {
            DB::rollBack();
            throw $th;
        }
    }

    public function requestFoundsList(){
        $requests = WalletMovements::with(['wallet' => function($query){
            $query->with(['user']);
        }])->where('bonus_type_id', null)
            ->where('status', 0)->get();

        return $requests;
    }

    public function rejectRequest(Request $request){
        $wallet_movement = WalletMovements::findOrFail($request->id);
        $wallet_movement->status = 2;
        $wallet_movement->update();
    }

    public function approveRequest(Request $request){
        
        $wallet_movement = WalletMovements::findOrFail($request->id);
        
       if ($request->hasFile('support_image')) {
            $image = $request->file('support_image');
            
            $formattedFilename = Helper::formatFilename($image->getClientOriginalName());
            
            $path = 'support_images/' . $formattedFilename;
            
            if ($wallet_movement->support_image) {
                $existingPath = str_replace(env('APP_URL') . '/storage/', '', $wallet_movement->support_image);
                Storage::disk('s3')->delete($existingPath);
            }

           $options = [
            'visibility' => 'public',
            'ContentDisposition' => 'attachment; filename="' . $formattedFilename . '"',
            ];
           
            Storage::disk('s3')->put($path, file_get_contents($image), $options);
            
            $wallet_movement->support_image = Storage::disk('s3')->url($path);
        }



        $wallet_movement->message = $request->message;
        
        $wallet_movement->status = 1;
        $wallet_movement->update();
    }
    
}
