<?php

namespace App\Services;

use App\Models\User;
use App\Models\Classified;
use Illuminate\Http\Resources\Json\JsonResource;
use Illuminate\Http\Resources\Json\AnonymousResourceCollection;

class TreeBinaryService
{
    public function listbinary(): AnonymousResourceCollection
    {
        $data = [];
        $currentUser =   User::find(auth()->user()->id);
        $data['c'] = $currentUser;

        $A = $this->findChildLeft($currentUser);
        $B = $this->findChildRight($currentUser);

        if ($A) {
            $A_id = $A->user->id;
        }
        if ($B) {
            $B_id = $B->user->id;
        }


        if (!empty($A) && $A_id != auth()->user()->id) {
            $data['a'] = $A;
            $Aa = $this->findChildLeft($A->user);
            $Ab = $this->findChildRight($A->user);

            if (!empty($Aa)) {
                $data['aa'] = $Aa;
            }
            if (!empty($Ab)) {
                $data['ab'] = $Ab;
            }
        }

        if (!empty($B) && $B_id != auth()->user()->id) {
            $data['b'] = $B;
            $Ba = $this->findChildLeft($B->user);
            $Bb = $this->findChildRight($B->user);

            if (!empty($Ba)) {
                $data['ba'] = $Ba;
            }
            if (!empty($Bb)) {
                $data['bb'] = $Bb;
            }
        }
        return JsonResource::collection($data);
    }

    private function findChildLeft($user)
    {
        $son_id = Classified::where('user_id', $user->id)
            ->pluck('user_position_left');
        if ($son_id) {
            $son = Classified::with('user')
                ->where('user_id', $son_id[0])
                ->first();
            return $son;
        } else {
            return null;
        }
    }

    private function findChildRight($user)
    {
        $son_id = Classified::where('user_id', $user->id)
            ->pluck('user_position_right');
        if ($son_id) {
            $son = Classified::with('user')
                ->where('user_id', $son_id[0])
                ->first();
            return $son;
        } else {
            return null;
        }
    }
}
