<?php namespace App\Services;

use App\Models\ClassroomPointDetail;
use App\Models\UserClassroomPoint;
use App\Models\UserLevel;

class UserLevelService 
{

    public function myPoints()
    {
        $user_id = auth()->user()->id;
        $points = UserClassroomPoint::select('total_points')->where('id_user',$user_id)->get()->first();
        if(is_null($points)){
            return 0;
        }
        return $points->total_points;
    }

    public function myPointsDetail()
    {
        $user_id = auth()->user()->id;
        $pointsDetail = ClassroomPointDetail::where('id_user_classroom_points',$user_id)->orderBy('increment_points','desc')->get()->take(5);
        return $pointsDetail;
    }

    public function getLevel()
    {
        $total_point = $this->myPoints();
        $level = UserLevel::whereBetween('experience_required',[0,$total_point])
                            ->orderBy('experience_required','desc')->get()->first();
        return $level;
    }

    public function nextLevel(){
        $level = $this->getLevel();
        $level = UserLevel::where('experience_required','>',$level->experience_required)
                            ->orderBy('experience_required','asc')->get()->first();
        return $level;
    }

    public function porcentaje()
    {   $total_point = $this->myPoints();
        $nextLevel = $this->nextLevel();
        $porce =  ($total_point / $nextLevel->experience_required ) * 100;

        return $porce;
    }


}
