import _mergeJSXProps from "babel-helper-vue-jsx-merge-props";
export default {
  name: 'LifeBuoyIcon',
  props: {
    size: {
      type: String,
      default: '24',
      validator: function validator(s) {
        return !isNaN(s) || s.length >= 2 && !isNaN(s.slice(0, s.length - 1)) && s.slice(-1) === 'x';
      }
    }
  },
  functional: true,
  render: function render(h, ctx) {
    var size = ctx.props.size.slice(-1) === 'x' ? ctx.props.size.slice(0, ctx.props.size.length - 1) + 'em' : parseInt(ctx.props.size) + 'px';
    var attrs = ctx.data.attrs || {};
    attrs.width = attrs.width || size;
    attrs.height = attrs.height || size;
    ctx.data.attrs = attrs;
    return h("svg", _mergeJSXProps([{
      attrs: {
        xmlns: "http://www.w3.org/2000/svg",
        width: "24",
        height: "24",
        viewBox: "0 0 24 24",
        fill: "none",
        stroke: "currentColor",
        "stroke-width": "2",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      },
      "class": "feather feather-life-buoy"
    }, ctx.data]), [h("circle", {
      attrs: {
        cx: "12",
        cy: "12",
        r: "10"
      }
    }), h("circle", {
      attrs: {
        cx: "12",
        cy: "12",
        r: "4"
      }
    }), h("line", {
      attrs: {
        x1: "4.93",
        y1: "4.93",
        x2: "9.17",
        y2: "9.17"
      }
    }), h("line", {
      attrs: {
        x1: "14.83",
        y1: "14.83",
        x2: "19.07",
        y2: "19.07"
      }
    }), h("line", {
      attrs: {
        x1: "14.83",
        y1: "9.17",
        x2: "19.07",
        y2: "4.93"
      }
    }), h("line", {
      attrs: {
        x1: "14.83",
        y1: "9.17",
        x2: "18.36",
        y2: "5.64"
      }
    }), h("line", {
      attrs: {
        x1: "4.93",
        y1: "19.07",
        x2: "9.17",
        y2: "14.83"
      }
    })]);
  }
};