import _mergeJSXProps from "babel-helper-vue-jsx-merge-props";
export default {
  name: 'SlidersIcon',
  props: {
    size: {
      type: String,
      default: '24',
      validator: function validator(s) {
        return !isNaN(s) || s.length >= 2 && !isNaN(s.slice(0, s.length - 1)) && s.slice(-1) === 'x';
      }
    }
  },
  functional: true,
  render: function render(h, ctx) {
    var size = ctx.props.size.slice(-1) === 'x' ? ctx.props.size.slice(0, ctx.props.size.length - 1) + 'em' : parseInt(ctx.props.size) + 'px';
    var attrs = ctx.data.attrs || {};
    attrs.width = attrs.width || size;
    attrs.height = attrs.height || size;
    ctx.data.attrs = attrs;
    return h("svg", _mergeJSXProps([{
      attrs: {
        xmlns: "http://www.w3.org/2000/svg",
        width: "24",
        height: "24",
        viewBox: "0 0 24 24",
        fill: "none",
        stroke: "currentColor",
        "stroke-width": "2",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      },
      "class": "feather feather-sliders"
    }, ctx.data]), [h("line", {
      attrs: {
        x1: "4",
        y1: "21",
        x2: "4",
        y2: "14"
      }
    }), h("line", {
      attrs: {
        x1: "4",
        y1: "10",
        x2: "4",
        y2: "3"
      }
    }), h("line", {
      attrs: {
        x1: "12",
        y1: "21",
        x2: "12",
        y2: "12"
      }
    }), h("line", {
      attrs: {
        x1: "12",
        y1: "8",
        x2: "12",
        y2: "3"
      }
    }), h("line", {
      attrs: {
        x1: "20",
        y1: "21",
        x2: "20",
        y2: "16"
      }
    }), h("line", {
      attrs: {
        x1: "20",
        y1: "12",
        x2: "20",
        y2: "3"
      }
    }), h("line", {
      attrs: {
        x1: "1",
        y1: "14",
        x2: "7",
        y2: "14"
      }
    }), h("line", {
      attrs: {
        x1: "9",
        y1: "8",
        x2: "15",
        y2: "8"
      }
    }), h("line", {
      attrs: {
        x1: "17",
        y1: "16",
        x2: "23",
        y2: "16"
      }
    })]);
  }
};