<?php

use App\Http\Controllers\Exam;
use App\Http\Controllers\GenerationalBonusController;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\ExamQuestion;
use App\Http\Controllers\DailyQuestion;
use App\Http\Controllers\PayController;
use App\Http\Controllers\BankController;
use App\Http\Controllers\RoleController;
use App\Http\Controllers\UserController;
use App\Http\Controllers\Auth\RegisterController;
use App\Http\Controllers\BadgeController;
use App\Http\Controllers\WalletPaymetMethodController;
use App\Http\Controllers\BonusController;
use App\Http\Controllers\PointController;
use App\Http\Controllers\VideoController;
use Illuminate\Support\Facades\Broadcast;
use App\Http\Controllers\CourseController;
use App\Http\Controllers\NiubizController;
use App\Http\Controllers\OptionController;
use App\Http\Controllers\WalletController;
use App\Http\Controllers\ChatGptController;
use App\Http\Controllers\PaymentController;
use App\Http\Controllers\ReportsController;
use App\Http\Controllers\CategoryController;
use App\Http\Controllers\LanguageController;
use App\Http\Controllers\SettingsController;
use App\Http\Controllers\BinaryCutController;
use App\Http\Controllers\DashboardController;
use App\Http\Controllers\RankBonusController;
use App\Http\Controllers\ShareLinkController;
use App\Http\Controllers\UserLevelController;
use App\Http\Controllers\Auth\LoginController;
use App\Http\Controllers\ClassifiedController;
use App\Http\Controllers\CourseGameController;
use App\Http\Controllers\AccountTypeController;
use App\Http\Controllers\GrowthBonusController;
use App\Http\Controllers\ModuleClassController;
use App\Http\Controllers\RamaBinariaController;
use App\Http\Controllers\RoleRequestController;
use App\Http\Controllers\UserRequestController;
use App\Http\Controllers\BinaryBranchController;
use App\Http\Controllers\CertificatesController;
use App\Http\Controllers\CourseModuleController;
use App\Http\Controllers\NotificationController;
use App\Http\Controllers\DefaultAvatarController;
use App\Http\Controllers\MiscellaneousController;
use App\Http\Controllers\PaymentMethodController;
use App\Http\Controllers\StartingBonusController;
use App\Http\Controllers\AdvertisementsController;
use App\Http\Controllers\UnverifiedUserController;
use App\Http\Controllers\UserExamHeaderController;
use App\Http\Controllers\PurchasedCourseController;
use App\Http\Controllers\WalletMovementsController;
use App\Http\Controllers\CourseGameDetailController;
use App\Http\Controllers\AccountTypeDetailController;
use App\Http\Controllers\Api\OPCController;
use App\Http\Controllers\FrequentQuestionsController;
use App\Http\Controllers\UnverifiedPaymentController;
use App\Http\Controllers\UserClassroomPointController;
use App\Http\Controllers\CourseConfigurationController;
use App\Http\Controllers\ClassroomPointConfigController;
use App\Http\Controllers\Templates\TemplateController;
use App\Http\Controllers\Templates\UserTemplateController;
use App\Http\Controllers\MarketplaceController;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Broadcast::routes(['middleware' => 'auth:admin']);

Auth::routes(['verify' => true]);
Route::get('/preview', [UserController::class, 'preview']);
Route::post('login', [LoginController::class, 'login2'])->name('main-login');
Route::get('login', [LoginController::class, 'showLoginForm'])->name('login-form');
Route::get('redirect-login', [LoginController::class, 'redirectToLoginWithMessage'])->name('redirect-with-message');
Route::post('/openpay-order', [OptionController::class, 'openpayOrder']);
Route::post('/verify-email', [RegisterController::class, 'verifyEmail']);
Route::post('/verify-document', [RegisterController::class, 'verifyDocument']);
Route::post('/verify-username', [RegisterController::class, 'verifyUsername']);
Route::post('/unverified-user/create', [UnverifiedUserController::class, 'create']);
Route::post('/unverified-payment/create', [UnverifiedPaymentController::class, 'create']);
Route::post('/test-webhook', [PaymentController::class, 'openpayWebhookConfirm']);

Route::group(['prefix' => 'pay'], function () {
    Route::post('/openpay', [PayController::class, 'payOpenpay'])->name('pay.openpay');
    Route::get('/membership', [PayController::class, 'viewMembershipPay'])->name('membership-view');
    Route::get('/membership/process/{ordenId}', [PayController::class, 'process'])->name('membership-process-paypal');
    Route::get('/membership-update/{membershipId}', [PayController::class, 'viewMembershipPayUpdate'])->name('membership-update-view');
    Route::get('/membership-update-process/{ordenId}/{membershipId}', [PayController::class, 'processUpdate'])->name('membership-update-process-paypal');
    Route::post('/membership-update-process-basic', [UserController::class, 'membershipUpdateBasic'])->name('membership-update-process-basic');
    Route::get('/recompra', [PayController::class, 'viewRecompra'])->name('recompra-view');
    Route::get('/opc-niubiz', [PayController::class, 'payOPC'])->name('opc-pay-niubiz');
    Route::get('/opc-openpay', [PayController::class, 'openpayOPC'])->name('opc-pay-openpay');
    Route::post('/opc-wallet', [PayController::class, 'payWallet']);
    Route::get('/membership-openpay/{id}', [PayController::class, 'openpayMembership']);
    Route::post('/membership-wallet', [PayController::class, 'payMembershipUpdate']);
    Route::get('/recharge-openpay/{amount}/{type_payment}', [PayController::class, 'openpayRecharge']);
    Route::post('/course-openpay', [PayController::class, 'openpayCourse']);
    Route::post('/recharge', [PayController::class, 'rechargeOpenpayProcess']);
    Route::post('/register', [PayController::class, 'registerOpenpayProcess']);
    Route::get('/get-openpay-conditions', [PaymentController::class, 'getOpenpayConditions']);
    Route::get('/recompra-process/{ordenId}', [PayController::class, 'processRecompra'])->name('recompra-process-paypal');
});

Route::group(['prefix' => 'rank_bonus'], function () {
    Route::get('/list', [RankBonusController::class, 'index']);
    Route::put('/update', [RankBonusController::class, 'store']);
});

Route::group(['prefix' => 'generational_bonus'], function () {
    Route::get('/list', [GenerationalBonusController::class, 'index']);
    Route::put('/update', [GenerationalBonusController::class, 'store']);
});

Route::group(['prefix' => 'opc_config'], function () {
    Route::get('/list', [OPCController::class, 'index']);
    Route::put('/update', [OPCController::class, 'store']);
});

Route::group(['prefix' => 'user'], function () {
    Route::get('/get-public-data/{name}', [UserController::class, 'getPublicUserData']);
    Route::get('/get-public-courses/{id}', [UserController::class, 'getPublicCourse']);
});

/* Rutas Programada - inicio */
/**
 * Todas las rutas establecidas deben de estar dentro de "Middleware Auth"
 */
Route::group(['middleware' => ['auth']], function () {

    Route::get('viewTree', [RamaBinariaController::class, 'getBinaryThreeData']);
    Route::view('uninivel', 'uninivel')->name('uninivel');
    Route::get('listbinary', [RamaBinariaController::class, 'listbinary']);
    Route::get('mypointslog', [PointController::class, 'getPointsForUser'])->name('mypointslog');
    // Main Page Route
    Route::get('/', [DashboardController::class, 'dashboardEcommerce'])->name('menu-dashboard')->middleware('verified');

    /* Route Dashboards */
    Route::group(['prefix' => 'dashboard'], function () {
        Route::get('analytics', [DashboardController::class, 'dashboardAnalytics'])->name('dashboard-analytics');
        Route::get('ecommerce', [DashboardController::class, 'dashboardEcommerce'])->name('dashboard-ecommerce');
    });
    /* Route Dashboards */

    /* Route Setting */
    Route::group(['prefix' => 'setting'], function () {
        Route::get('profile', [UserController::class, 'viewProfileSetting'])->name('setting-profile');
        Route::get('countrys', [UserController::class, 'getCountries'])->name('setting-country');
        Route::post('update-notifications', [NotificationController::class, 'update'])->name('update-notifications');
    });

    /*Router roles*/
    Route::group(['prefix' => 'roles'], function () {
        Route::get('currentRole', [RoleController::class, 'roleCurrentUser'])->name('current-role');
    });

    Route::group(['prefix' => 'system'], function () {
        Route::get('binary-branch', [BinaryBranchController::class, 'binary_branch'])->name('binary-branch');
    });

    Route::group(['prefix' => 'payment'], function () {
        Route::get('/', [PaymentController::class, 'index'])->name('payment');
        Route::get('/list', [PaymentController::class, 'List'])->name('payment-list');
        Route::get('/get-all', [PaymentController::class, 'getAll']);
        Route::get('/get-all-user/{id}', [PaymentController::class, 'getAllUser']);
    });

    Route::group(['prefix' => 'users'], function () {
        Route::get('/list', [UserController::class, 'list'])->name('users-list');
        Route::post('/update-user', [UserController::class, 'updateUser'])->name('update-user');
        Route::post('/update-password', [UserController::class, 'updatePassword'])->name('update-password');
        Route::get('/sha/{purchase_operation_number}/{purchase_amount}', [UserController::class, 'credentials']);
        Route::get('/get-data-user/{name}', [UserController::class, 'getDataUser']);
        Route::get('/get-data-user-id/{id}', [UserController::class, 'getDataUserId']);
        Route::get('/get-data-currentuser', [UserController::class, 'getDataCurrentUser']);
        Route::post('/change-position-currentuser', [UserController::class, 'changePositionCurrentUser']);
        /*Start api users*/
        Route::get('/api', [BinaryBranchController::class, 'getListUsersMembreship'])
            ->name('getListUsersMembreship');
        Route::get('/api/my-directs', [BinaryBranchController::class, 'getMyDirects']);
        Route::get('/api/list', [UserController::class, 'GetList'])
            ->name('GetList');
        Route::get('get-bonuses', [BonusController::class, 'index']);
        Route::post('/change-role', [RoleRequestController::class, 'changeRole']);
        /*End api users*/
    });

    //account types Routes
    Route::group(['prefix' => '/account-type'], function () {
        //view
        Route::get('get-data-id/{id}', [AccountTypeController::class, 'getDataBytId']);
        Route::get('/', [AccountTypeController::class, 'retornarVista'])->name('account-type');
        //api
        Route::apiResource('accountType', AccountTypeController::class);
        //history membership of user
        Route::get('/detail/membership-history', [AccountTypeDetailController::class, 'getHistoryOfUserMembership']);
    });

    //account types Routes
    Route::group(['prefix' => '/starting-bonus'], function () {
        //view
        Route::get('/', [StartingBonusController::class, 'retornarVista'])->name('starting-bonus');
        //api
        Route::apiResource('startingBonus', StartingBonusController::class)->except(['update']);
    });

    Route::group(['prefix' => 'user-levels'], function () {
        Route::get('/', [UserLevelController::class, 'index'])->name('user-levels-index');
        Route::get('/list', [UserLevelController::class, 'showAll'])->name("showAll");
        Route::post('/createUpdate', [UserLevelController::class, 'createUpdate'])->name('createUpdate');
        Route::get('/list-my-info', [UserLevelController::class, 'getInfoUser'])->name('list-badges');
        Route::get('/num-ranking', [UserClassroomPointController::class, 'getPosicionRanking'])->name('n_ranking');
    });

    Route::group(['prefix' => 'notifications'], function () {
        Route::get('/', [NotificationController::class, 'create'])->name('index');
        Route::get('/list', [NotificationController::class, 'myNotifications'])->name('notifications-list');
    });

    Route::group(['prefix' => 'badges'], function () {
        Route::get('/', [BadgeController::class, 'create'])->name('create-badge');
        Route::get('/list-all', [BadgeController::class, 'getAll'])->name("badges-list");
        Route::post('/store', [BadgeController::class, 'store'])->name('store-badge');
        Route::get('/my-badges', [BadgeController::class, 'myBadges'])->name('my-badges');
        Route::get('/get-my-badges', [BadgeController::class, 'getMyBadges'])->name('get-my-badges');
        Route::post('/update', [BadgeController::class, 'update'])->name('update');
    });

    //account types Routes
    Route::group(['prefix' => '/growth-bonus'], function () {
        //view
        Route::get('/', [GrowthBonusController::class, 'retornarVista'])->name('growth-bonus');
        //api
        Route::apiResource('growthBonus', GrowthBonusController::class)->except(['update']);
    });

    Route::group(['prefix' => 'config'], function () {
        Route::resource('binarycut', BinaryCutController::class)->only(['index', 'store']);
    });

    Route::prefix('binary-cut')->group(function () {
        Route::get('/', [BinaryCutController::class, 'index'])->name('binarycut.index');
        Route::post('/', [BinaryCutController::class, 'store'])->name('binarycut.store');
        Route::get('/history', [BinaryCutController::class, 'history'])->name('binarycut.history');
        Route::get('/history/{user}', [BinaryCutController::class, 'userHistory'])->name('binarycut.user-history');
    });

    //Admin
    Route::group(['prefix' => 'config/certificates'], function () {
        Route::get('/', [CertificatesController::class, 'index'])->name('configuration-certificates');
        Route::get('/list', [CertificatesController::class, 'showAll']);
        Route::post('/add', [CertificatesController::class, 'addCertificate']);
        Route::delete('/{id}', [CertificatesController::class, 'destroyCertificate']);
    });

    Route::group(['prefix' => 'config/settings'], function () {
        Route::get('/', [SettingsController::class, 'index'])->name('config-settings');
        Route::get('/points', [SettingsController::class, 'getPoints']);
        Route::post('/points', [SettingsController::class, 'savePoints']);
    });

    //Productor
    Route::group(['prefix' => 'certificates'], function () {
        Route::post('/save', [CertificatesController::class, 'saveConfigCertificate']);
    });

    Route::group(['prefix' => 'config/frequent-questions'], function () {
        Route::get('/', [FrequentQuestionsController::class, 'index'])->name('frequent-questions');
        Route::get('/list', [FrequentQuestionsController::class, 'showAll']);
        Route::post('/add', [FrequentQuestionsController::class, 'store']);
        Route::post('/update', [FrequentQuestionsController::class, 'update']);
        Route::post('/status', [FrequentQuestionsController::class, 'changeStatus']);
        Route::delete('/{id}', [FrequentQuestionsController::class, 'destroy']);
    });

    Route::group(['prefix' => 'config/bank'], function () {
        Route::get('/', [BankController::class, 'index'])->name('bank');
        /*Start api config bank*/
        Route::get('/detail/{id}', [BankController::class, 'Detail'])->name('bank-detail');
        Route::get('/list', [BankController::class, 'List'])->name('bank-lit');
        Route::post('/add', [BankController::class, 'Add'])->name('bank-add');
        Route::post('/edit', [BankController::class, 'Edit'])->name('Edit');
        Route::delete('/delete/{id}', [BankController::class, 'Delete'])->name('Delete');
        /*End api config bank*/
    });

    Route::group(['prefix' => 'config/advertisements'], function () {
        Route::get('/', [AdvertisementsController::class, 'index'])->name('advertisements');
        /*Start api config messages*/
        Route::get('/detail/{id}', [AdvertisementsController::class, 'Detail'])->name('advertisements-detail');
        Route::get('/list', [AdvertisementsController::class, 'List'])->name('advertisements-list');
        Route::post('/add', [AdvertisementsController::class, 'Add'])->name('advertisements-add');
        Route::put('/edit/{id}', [AdvertisementsController::class, 'Edit'])->name('advertisements-edit');
        Route::delete('/delete/{id}', [AdvertisementsController::class, 'Delete'])->name('advertisements-delete');
        /*End api config messages*/
    });

    Route::group(['prefix' => 'config/payment-method'], function () {
        Route::get('/', [PaymentMethodController::class, 'index'])->name('payment-method');
        /*Start api config payment-method*/
        Route::get('/detail/{id}', [PaymentMethodController::class, 'Detail'])->name('payment-method-detail');
        Route::get('/list', [PaymentMethodController::class, 'List']);
        Route::get('/list-array', [PaymentMethodController::class, 'listPaymentMethods'])->name('payment-method-list-array-web');
        Route::post('/add', [PaymentMethodController::class, 'Add'])->name('payment-method-add');
        Route::put('/edit/{id}', [PaymentMethodController::class, 'Edit'])->name('payment-method-edit');
        Route::delete('/delete/{id}', [PaymentMethodController::class, 'Delete'])->name('payment-method-delete');
        /*End api config payment-method*/
    });

    // User Request    
    Route::group(['prefix' => 'config/user-request'], function () {
        Route::view('/', 'content.config.user_request')->middleware('can:new-users')->name('user-request');
        Route::get('/list', [UserRequestController::class, 'index']);
        Route::get('/get-user-by-id/{id}', [UserRequestController::class, 'getUserById']);
        Route::post('/update-unverified-request', [UserRequestController::class, 'updateUnverifiedRequest']);
    });

    Route::group(['prefix' => 'config/role-request'], function () {
        Route::view('/', 'content.config.role-request');
        Route::get('/list', [UserController::class, 'listUserRoleRequest']);
        Route::get('/get', [RoleRequestController::class, 'getRoleRequest']);
        Route::patch('/confirm-change', [RoleRequestController::class, 'confirmChange']);
        Route::patch('/reject-change', [RoleRequestController::class, 'rejectChange']);
    });

    Route::group(['prefix' => 'config/category'], function () {
        Route::view('/', 'content.category.index')->name('category-index');
        Route::view('/create', 'content.category.create')->name('category.create');
        Route::post('/store', [CategoryController::class, 'store'])->name('category.store');
        Route::post('/update', [CategoryController::class, 'update'])->name('category.update');
    });

    //CONFIG CLASSROOM POINTS
    Route::group(['prefix' => 'config/classroom-point-config'], function () {
        Route::view('/', 'content.config.classroom-point-config');
        Route::get('/list', [ClassroomPointConfigController::class, 'show'])->name('classroom-point-config');
        Route::get('/{classroomPointConfig}/edit', [ClassroomPointConfigController::class, 'edit']);
        Route::post('/{id}/update', [ClassroomPointConfigController::class, 'update']);
    });

    //CONFIG OPTIONS
    Route::group(['prefix' => 'config/option'], function () {
        Route::get('/list', [OptionController::class, 'show'])->name('option');
        Route::post('/update', [OptionController::class, 'update']);
        Route::get('/avatars/list', [DefaultAvatarController::class, 'show']);
        Route::post('/avatars/add', [DefaultAvatarController::class, 'store']);
        Route::delete('/avatars/delete/{id}', [DefaultAvatarController::class, 'delete']);
    });

    Route::group(['prefix' => 'config/share-link'], function () {
        //view
        Route::view('/', 'content.config.share-link')->name('config.share-link');

        // Asegúrate de que estas rutas estáticas estén antes de las rutas dinámicas
        Route::post('/add', [ShareLinkController::class, 'Add'])->name('share-link-add');
        Route::put('/edit/{id}', [ShareLinkController::class, 'Edit'])->name('share-link-edit');
        Route::delete('/delete/{id}', [ShareLinkController::class, 'Delete'])->name('share-link-delete');

        // La ruta dinámica debe ir después de las rutas estáticas
        Route::get('/{username}', [ShareLinkController::class, 'retornarVista'])->name('share-link-detail');

        //api
        Route::apiResource('shareLink', ShareLinkController::class)->except(['update']);
    });

    Route::group(['prefix' => 'course'], function () {
        Route::get('/', [CourseController::class, 'index'])->name('courses.index');
        Route::get('/categories', [CourseController::class, 'categoriesList'])->name('course.categories');
        Route::get('/levels', [CourseController::class, 'levelsList'])->name('course.levels');
        Route::get('/create', [CourseController::class, 'create'])->name('courses.create');
        Route::get('/{id}/courseList', [CourseController::class, 'courseList'])->name('course.list');
        Route::get('/courseListVerification', [CourseController::class, 'courseListVerification'])->name('course.listVerification');
        Route::post('/store-course', [CourseController::class, 'storeCourse']);
        Route::delete('/delete/{id}', [CourseController::class, 'delete']);
        Route::post('/{id}/sendRequest', [CourseController::class, 'sendRequest'])->name('courses.sendRequest');
        Route::post('/{id}/update', [CourseController::class, 'update'])->name('courses.update');
        Route::get('/{id}/subscribersList', [CourseController::class, 'subscribersList'])->name('course.subscribersList');
        Route::get('/{id}/modulesList', [CourseController::class, 'modulesList'])->name('course.modulesList');
        Route::get('/{id}/orders', [CourseController::class, 'getOrders']);
        Route::patch('/change-order', [CourseController::class, 'changeOrder']);
        Route::patch('/change-order-module', [CourseController::class, 'changeOrderModule']);

        Route::group(['prefix' => '/module'], function () {
            Route::post('/store', [CourseModuleController::class, 'store'])->name('module.store'); // action
            Route::get('/{id}/editModule', [CourseModuleController::class, 'editModule'])->name('module.editModule'); //view
            Route::put('/{id}/update', [CourseModuleController::class, 'update'])->name('module.update'); //action
            Route::delete('/{id}/delete', [CourseModuleController::class, 'delete'])->name('module.delete');

            Route::group(['prefix' => '/class'], function () {
                Route::post('/{id}/save', [ModuleClassController::class, 'save'])->name('class.save');
                Route::delete('/{id}/delete', [ModuleClassController::class, 'delete'])->name('class.delete');
                Route::get('/{id}/classList', [ModuleClassController::class, 'getClassList'])->name('class.list');
                Route::get('/{id}/listObservations', [ModuleClassController::class, 'listObservations'])->name('class.listObservations');
                Route::get('/{id}/details', [ModuleClassController::class, 'getClassDetails'])->name('class.details');
                Route::post('/{id}/update', [ModuleClassController::class, 'update'])->name('class.update');
                Route::get('/generate-url', [VideoController::class, 'generatePresignedUrl']);
                Route::get('/update-video-url/{id}/{name}', [VideoController::class, 'updateVideo']);
            });
        });

        Route::group(['prefix' => '/subscriber'], function () {
            Route::get('/', [CourseController::class, 'subscribers'])->name('courses.subs'); //view
        });

        Route::group(['prefix' => '/verification'], function () {
            Route::get('/', [CourseController::class, 'verification'])->name('courses.verification'); //view
            Route::get('/{id}/review', [CourseController::class, 'review'])->name('course.review'); //view
            Route::post('/{id}/approved', [CourseController::class, 'approved'])->name('course.verification.approved');
            Route::post('/{id}/sendObservations', [CourseController::class, 'sendObservations'])->name('course.verification.sendObservations');

            Route::group(['prefix' => '/class'], function () {
                Route::post('/changeStatus', [ModuleClassController::class, 'changeStatus'])->name('course.review.changeStatus');
            });
        });

        Route::group(['prefix' => '/exam'], function () {

            Route::post('/store', [Exam::class, 'store']);
            Route::get('{id}/create', [Exam::class, 'create'])->name('exam-create');
            Route::get('/{id}/createModuleExam', [Exam::class, 'createModuleExam'])->name('exam-module-create');
            Route::get('/{id}/createLessonExam', [Exam::class, 'createLessonExam'])->name('exam-lesson-create');
            Route::get('/{id}/list', [Exam::class, 'list']);
            Route::get('/module/{id}/list', [Exam::class, 'moduleList']);
            Route::get('/lesson/{id}/list', [Exam::class, 'lessonList']);
            Route::get('/edit/{id}', [Exam::class, 'edit'])->name('exam-edit');
            Route::get('/module/edit/{id}', [Exam::class, 'moduleEdit'])->name('exam-module-edit');
            Route::get('/lesson/edit/{id}', [Exam::class, 'lessonEdit'])->name('exam-lesson-edit');
            Route::get('/lesson/all', [Exam::class, 'allLessonsExam']);
            Route::post('/activate', [Exam::class, 'activate']);
            Route::get('/preview/{id}', [Exam::class, 'preview']);
            Route::get('/rate', [UserExamHeaderController::class, 'index'])->name('exams.rate');
            Route::get('/rate/{id}/list', [UserExamHeaderController::class, 'list'])->name('exams.list');
            Route::get('/rate/{id}/detailList', [UserExamHeaderController::class, 'detailList'])->name('exams.detailList');
            Route::post('/rate/update', [UserExamHeaderController::class, 'update'])->name('exams.rate.update');

            Route::group(['prefix' => '/question'], function () {
                Route::get('/{exam_id}/list', [ExamQuestion::class, 'list']);
                Route::get('/{id}/get', [ExamQuestion::class, 'get']);
                Route::get('/{id}/edit', [ExamQuestion::class, 'edit'])->name('exam.question.edit');
                Route::post('/store', [ExamQuestion::class, 'store']);
                Route::post('/options/store', [ExamQuestion::class, 'optionsStore']); // save options from a question
                Route::delete('/{id}/delete', [ExamQuestion::class, 'delete']);
            });
        });

        Route::group(['prefix' => '/game'], function () {
            Route::get('/{id}', [CourseGameController::class, 'index'])->name('game-create');
            Route::post('/store', [CourseGameController::class, 'store'])->name('game.store');
            Route::get('/{id}/list', [CourseGameController::class, 'list']);
            Route::get('/edit/{id}', [CourseGameController::class, 'edit']);
            Route::post('/storeDetail', [CourseGameDetailController::class, 'storeDetail']); // update detail

            # Module Games
            Route::get('/module/{id}', [CourseGameController::class, 'indexModule'])->name('course.game.module');
            Route::get('/module/{id}/list', [CourseGameController::class, 'moduleList']);

            # Lesson Games
            Route::get('/lesson/{id}', [CourseGameController::class, 'indexLesson'])->name('course.game.lesson');
            Route::get('/lesson/{id}/list', [CourseGameController::class, 'lessonList']);

            Route::group(['prefix' => '/item'], function () {
                Route::post('/store', [CourseGameDetailController::class, 'storeItem']); // store item
                Route::get('/{id}/list', [CourseGameDetailController::class, 'listItem']); // list item
                Route::delete('/{id}/{index}/delete', [CourseGameDetailController::class, 'deleteItem']); // delete item by game_id and index json
                Route::post('/owl/store', [CourseGameDetailController::class, 'storeOwlQuestion']);
                Route::post('/owl/update', [CourseGameDetailController::class, 'updateOwlQuestion']);
                Route::post('/owl/update-lifes', [CourseGameDetailController::class, 'updateLifes']);
                Route::post('/wordWheel/store', [CourseGameDetailController::class, 'storeWheelQuestion']);
                Route::post('/wordWheel/update', [CourseGameDetailController::class, 'updateWheelQuestion']);
                Route::post('/complete-text/store', [CourseGameDetailController::class, 'storeCompleteText']);
                Route::post('/order-words/store', [CourseGameDetailController::class, 'storeOrderWords']);
                Route::post('/order-words/update', [CourseGameDetailController::class, 'updateOrderWords']);
            });

            Route::post('/activate', [CourseGameController::class, 'activate']);
        });

        Route::group(['prefix' => '/certificate'], function () {
            Route::get('/{id}', [CourseController::class, 'configureCertificate']);
            Route::get('/configuration/{id}', [CourseController::class, 'getConfigureCertificate']);
            Route::post('/store/configuration', [CourseConfigurationController::class, 'store']);
            Route::post('/deliver-certificate', [PurchasedCourseController::class, 'deliverCertificate']);
        });
    });

    Route::group(['prefix' => 'marketplace'], function () {
        Route::get('/', [MarketplaceController::class, 'viewMarketPlaceManagement'])->name('marketplace-management');
        Route::post('/toggle-sellable/{courseId}', [MarketplaceController::class, 'toggleMarketplaceViewability']);
    });

    Route::group(['prefix' => '/quizz'], function () {
        Route::get('/daily', [DailyQuestion::class, 'get'])->name('quiz-daily');
    });

    Route::group(['prefix' => '/reports'], function () {
        Route::get('/growthBonus', [ClassifiedController::class, 'growthBonus'])->name('report-growthBonus');
        Route::get('/startingBonus', [ClassifiedController::class, 'startingBonus'])->name('report-startingBonus');
        Route::get('/mywalletinfo/{username}', [WalletController::class, 'getWalletForUser'])->name('report-mywalletinfo');
        Route::view('/wallets', 'content.reports.wallet')->middleware('can:report-wallets')->name('report-wallets');
        Route::get('/walletslist', [WalletController::class, 'getTotalWalletUsers']);
        Route::post('/movements/transfer-founds', [WalletMovementsController::class, 'transferFounds']);
        Route::post('/movements/request-founds/approve', [WalletMovementsController::class, 'approveRequest']);
        Route::patch('/movements/request-founds/reject', [WalletMovementsController::class, 'rejectRequest']);
        Route::get('/movements/request-founds/list', [WalletMovementsController::class, 'requestFoundsList']);
        Route::post('/movements/request-founds', [WalletMovementsController::class, 'requestFounds']);
        Route::get('/mymovements/{user_id}', [WalletMovementsController::class, 'getAllMovementsWallet']);
        Route::get('/movements/all', [WalletMovementsController::class, 'getAllMovementsHistoryWallet']);
        Route::get('/mywallet', [ReportsController::class, 'viewOption'])->middleware('can:report-nmywallet')->name('report-nmywallet');
        Route::get('/config', [ReportsController::class, 'config']);
        Route::get('/mypurchase', [ReportsController::class, 'myPurchase'])->middleware('can:report-purchase')->name('report-purchase');
        Route::get('/mysales', [ReportsController::class, 'mySales'])->middleware('can:report-sales')->name('report-sales-my');
        Route::get('/getsales/{id}', [ReportsController::class, 'getSales'])->middleware('can:report-sales')->name('report-sales');
        Route::get('/wallet-methods', [WalletPaymetMethodController::class, 'getAll']);
        Route::get('/historial', [ReportsController::class, 'historial'])->middleware('can:report-historial')->name('report-historial');
        Route::get('/get-binary-history', [ReportsController::class, 'getBinaryHistory'])->name('get-binary-history');
        //Route::get('/proyeccion', [ReportsController::class, 'proyeccion'])->middleware('can:report-proyeccion')->name('report-proyeccion');
    });

    Route::get('/chatgpt', [ChatGptController::class, 'index'])->name('chatgpt.index');
    Route::get('/chats/all/{id}', [ChatGptController::class, 'getChat']);
    Route::post('/chat', [ChatGptController::class, 'store']);
    Route::post('/chat/chatgpt', [ChatGptController::class, 'chat']);
    Route::post('/chat/chatpdf', [ChatGptController::class, 'subirPDF']);

    Route::group(['prefix' => '/requests'], function () {
        Route::get('/listUserPayments ', [PaymentController::class, 'listUserPayments']);
        Route::get('/listMyPayments ', [PaymentController::class, 'listMyPayments'])->name('request-listMyPayments');

        //Ruta Billetera - Fondos de Usuario
        Route::group(['prefix' => '/wallet'], function () {
            Route::get('/', [WalletController::class, 'retornarVista'])->name('wallet');
            Route::apiResource('wallets', WalletController::class)->only('index');
        });
    });
    Route::post('/logout', [LoginController::class, 'logout'])->name('logout');

    Route::group(['prefix' => 'courses'], function () {
        Route::get('/list/producer', [CourseController::class, 'listCoursesProd'])->name('listCoursesProd');
    });

    Route::group(['prefix' => 'admin'], function () {
        Route::get('/role/get-actions', [RoleController::class, 'getActions']);
        Route::get('/role/get-modules', [RoleController::class, 'getModules']);
        Route::resource('role', RoleController::class);
        Route::get('/role/show', [RoleController::class, 'show']);
        Route::get('/role/get-sections/{id}', [RoleController::class, 'getSections']);
        Route::get('/role/submodule/{role}/{modul}', [RoleController::class, 'submodule']);
        Route::post('/role/actions', [RoleController::class, 'actions']);
        Route::post('/role/add/permission', [RoleController::class, 'addPermission']);
        Route::post('/role/remove/permission', [RoleController::class, 'removePermission']);
        Route::get('/role/remove/{role}', [RoleController::class, 'removeRole']);
    });
});

Route::group(['prefix' => 'templates'], function () {
    Route::post('/store', [TemplateController::class, 'store']);
    Route::get('/show/{id}', [TemplateController::class, 'show']);
    Route::put('/update/{id}', [TemplateController::class, 'update']);
    Route::delete('/delete/{id}', [TemplateController::class, 'delete']);
});

Route::group(['prefix' => 'user-templates'], function () {
    Route::get('/content/{id}', [UserTemplateController::class, 'getContent']);
    Route::post('/store', [UserTemplateController::class, 'store']);
    Route::get('/list/{userId}', [UserTemplateController::class, 'list']);
    Route::put('/update/{id}', [UserTemplateController::class, 'update']);
    Route::delete('/delete/{id}', [UserTemplateController::class, 'delete']);
});

Route::get('/webpage/{code}', [UserTemplateController::class, 'show']);
//registro de usuarios
Route::post('users/create', [UserController::class, 'Create'])->name('users-create');
Route::post('users/create-free', [UserController::class, 'createFree'])->name('users-create-free');
Route::post('users/validate', [UserController::class, 'validateUser'])->name('users-create-session');
Route::post('/users/create-free1', [UserController::class, 'createFree1']);

// for general users
Route::get('/register/{id}/{code}', [UserController::class, 'RegisterSponsor'])->name('users-register');
/* Rutas Programada - fin */

Route::group(['prefix' => 'page'], function () {
    // Miscellaneous Pages With Page Prefix
    Route::get('coming-soon', [MiscellaneousController::class, 'coming_soon'])->name('misc-coming-soon');
    Route::get('not-authorized', [MiscellaneousController::class, 'not_authorized'])->name('misc-not-authorized');
    Route::get('maintenance', [MiscellaneousController::class, 'maintenance'])->name('misc-maintenance');
});

/* Route Pages */

// Nibuiz routes
Route::get('/niubiz/payment', [NiubizController::class, 'index'])->name('niubiz-index');
Route::get('/get-different-access-token', [NiubizController::class, 'createNiubizToken'])->name('createNiubizToken');
Route::post('/authorizeTransaction', [NiubizController::class, 'authorizeTransaction'])->name('authorizeTransaction');
Route::post('/authorizeopc', [PayController::class, 'authorizeopc'])->name('authorizeopc');
Route::post('/niubiz/process', [NiubizController::class, 'process'])->name('niubiz-process');
Route::post('/opc/process', [PayController::class, 'opcprocess'])->name('opc-process');
Route::get('/terms-and-conditions', [UserController::class, 'conditions'])->name('conditions');
Route::get('/error', [MiscellaneousController::class, 'error'])->name('error');

// map leaflet

// locale Route
Route::get('lang/{locale}', [LanguageController::class, 'swap']);
Route::view('/virtualclassroom', 'newPage')->name('virtualclass');
Route::get('/screenshot', [CertificatesController::class, 'screenshot']);
Route::get('/get-certificado', [CertificatesController::class, 'getCertificado']);
Route::get('/course-user/dynamic/{id}', [CourseGameController::class, "previewGame"]);
Route::get('/api/obtener-tiempo-restante', [ShareLinkController::class, 'obtenerTiempoRestante']);
Route::get('/api/verificar-enlace/{id}', [ShareLinkController::class, 'verificarEnlace']);
Route::get('/check-link-status/{username}', [ShareLinkController::class, 'checkLinkStatus']);
