<?php $__env->startSection('title', 'Login Page'); ?>

<?php $__env->startSection('page-style'); ?>
    
    <link rel="stylesheet" href="<?php echo e(asset(mix('css/base/pages/page-auth.css'))); ?>">
    <style>
        .password-container {
            position: relative;
        }

        .toggle-password {
            position: absolute;
            right: 15px;
            top: 70%;
            transform: translateY(-50%);
            cursor: pointer;
            color: #6c757d;
            z-index: 10;
        }

        .g-recaptcha-container {
            display: flex;
            justify-content: center;
            width: 100%;
        }

        @media (max-width: 576px) {
            .g-recaptcha {
                transform: scale(0.80);
                transform-origin: center;
            }

            .g-recaptcha-container {
                width: 100%;
            }
        }
    </style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="position-relative" style="z-index: 1">
        <div class="position-absolute top-0 start-50 translate-middle-x col-12">
            
            <?php if(session('success')): ?>
                <div role="alert" class="alert alert-success col-10 m-auto">
                    <div class="alert-body text-center">
                        <span><?php echo e(session('success')); ?>!</span>
                        <button type="button" class="close" data-dismiss="alert" aria-label="Cerrar">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                </div>
            <?php elseif(session('warning')): ?>
                <div role="alert" class="alert alert-warning col-10 m-auto">
                    <div class="alert-body text-center">
                        <span><?php echo e(session('warning')); ?>!</span>
                        <button type="button" class="close" data-dismiss="alert" aria-label="Cerrar">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                </div>
            <?php endif; ?>
        </div>
    </div>
    <div class="auth-wrapper auth-v1 px-2" style="background: #0b0f12ee">
        <div class="auth-inner py-2 back-gris" style="background: #35424a">
            <!-- Tarjeta de Inicio de Sesión -->
            <div class="card mb-0 back-gris">
                <div class="card-body">

                    <span class="brand-logo">
                        
                        <img src="<?php echo e(asset('images/logo/promolider_logo.png')); ?>" style="min-width: 130px;width:50%">
                    </span>

                    <h4 class="card-title mb-1 color-text-green">¡Bienvenido a Promolíder! 👋</h4>
                    <p class="card-text mb-2 color-text-white">Inicia sesión con tu cuenta y comienza la aventura</p>

                    <form class="auth-login-form mt-2" method="POST" action="<?php echo e(route('main-login')); ?>">
                        <?php echo csrf_field(); ?>
                        
                        <input type="hidden" name="user_timezone" id="user_timezone" />

                        <div class="form-group <?php echo e($errors->has('username') ? 'has-error' : ''); ?>">
                            <label for="login-user" class="form-label color-text-green">Usuario</label>
                            
                            <input type="text" autocomplete="off"
                                class="form-control input-back <?php $__errorArgs = ['username'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" id="login-user"
                                name="username" aria-describedby="login-user" tabindex="1" autofocus
                                value="<?php echo e(old('username')); ?>" placeholder="Ingrese su nombre de usuario" />
                            <?php $__errorArgs = ['username'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <span class="invalid-feedback" role="alert">
                                    <strong><?php echo e($message); ?></strong>
                                </span>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        <div class="form-group password-container <?php echo e($errors->has('password') ? 'has-error' : ''); ?>">
                            <label for="login-password" class="form-label color-text-green">Contraseña</label>
                            
                            <input type="password" class="form-control input-back <?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                id="login-password" name="password" tabindex="2" aria-describedby="login-password"
                                placeholder="Ingrese su contraseña" />
                            <span class="toggle-password" onclick="togglePasswordVisibility()">
                                <i class="fas fa-eye-slash" id="eye-icon"></i>
                            </span>
                            <?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <span class="invalid-feedback" role="alert">
                                    <strong><?php echo e($message); ?></strong>
                                </span>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        <div class="form-group">
                            <div class="custom-control custom-checkbox">
                                
                                <input class="custom-control-input input-back" type="checkbox" id="remember-me"
                                    name="remember-me" tabindex="3" <?php echo e(old('remember-me') ? 'checked' : ''); ?> />
                                <label class="custom-control-label color-text-white" for="remember-me"> Recuérdame </label>
                            </div>
                        </div>

                        <div class="form-group <?php echo e($errors->has('g-recaptcha-response') ? 'has-error' : ''); ?>">
                            
                            <div class="g-recaptcha-container">
                                <?php echo htmlFormSnippet(); ?>

                            </div>
                            <?php $__errorArgs = ['g-recaptcha-response'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <span class="invalid-feedback text-center" role="alert" style="display: block">
                                    <strong><?php echo e($message); ?></strong>
                                </span>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        
                        <button type="submit" class="btn back-green btn-block color-text-white" tabindex="4">Iniciar
                            sesión</button>
                    </form>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('page-script'); ?>
    <script>
        // Configura la zona horaria del usuario al cargar la página
        document.addEventListener('DOMContentLoaded', function() {
            var userTimezone = Intl.DateTimeFormat().resolvedOptions().timeZone;
            document.getElementById('user_timezone').value = userTimezone;
        });

        // Alternar visibilidad de la contraseña
        function togglePasswordVisibility() {
            var passwordInput = document.getElementById('login-password');
            var eyeIcon = document.getElementById('eye-icon');

            if (passwordInput.type === 'password') {
                passwordInput.type = 'text';
                eyeIcon.classList.remove('fa-eye-slash');
                eyeIcon.classList.add('fa-eye');
            } else {
                passwordInput.type = 'password';
                eyeIcon.classList.remove('fa-eye');
                eyeIcon.classList.add('fa-eye-slash');
            }
        }
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts/fullLayoutMaster', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/promolider/public_html/crm/resources/views//auth/login.blade.php ENDPATH**/ ?>