<?php

namespace App\Console\Commands;

use App\Mail\EmailFractionedPaymentsMailable;
use Illuminate\Console\Command;
use Carbon\Carbon;
use Illuminate\Support\Facades\Mail;
use App\Models\User;

class EmailFractionedPayments extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'mail:EmailFractionedPayments';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Command description';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        $users = User::join('product_payments', 'product_payments.user_id', 'users.id')
            ->join('fractioned_payments', 'fractioned_payments.payment_id', 'product_payments.id')
            ->select('users.created_at', 'users.name', 'users.email','fractioned_payments.fecha_pago')
            ->where('product_payments.is_fractioned',1)
            ->get();

        foreach ($users as $user) {

            
            $fechaPago = Carbon::parse($user->fecha_pago);

            $now = Carbon::now();

            $diff = ($now->diff($fechaPago)->days);

            if ($diff == 2) {
                $data = (object) array('username' => $user->name);
                $content = new EmailFractionedPaymentsMailable($data);

                Mail::to($user->email)
                    ->cc($user->email)
                    ->bcc($user->email)
                    ->send($content); 
            }
        }
        echo ('Comando funcionando');
        echo (count($users));
        return 0;
    }
}
