<?php

namespace App\Http\Controllers;

use App\Helpers\Helper;
use App\Models\Producto;
use App\Models\Video;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Storage;
use App\Traits\ResponseFormat;
use Aws\Exception\MultipartUploadException;
use Aws\Glacier\GlacierClient;
use Aws\Glacier\MultipartUploader;
use Aws\S3\MultipartUploader as S3MultipartUploader;
use Aws\S3\ObjectUploader;
use Aws\S3\S3Client;

class VideoController extends Controller
{
    use ResponseFormat;

    public function updateStatus(Request $request)
    {
        $video = Video::findOrFail($request->id);
        $video->status = 1;
        $video->update();
    }

    public function saveTime(Request $request)
    {
        $video = Video::findOrFail($request->id);
        $video->saved_time = $request->time;
        $video->save();

        return $this->responseOk('', 'video time saved');
    }

    public function showTime(Request $request)
    {
        $video = Video::findOrFail($request->id);
        $video_time = $video->saved_time;

        return $this->responseOk('', $video_time);
    }

    public static function storeClassVideo($file, $user_id, $course_id, $class_id)
    {
        $course_type = Producto::where('id', $course_id)
            ->select('tipo_producto_id')
            ->first();
        $type = $course_type->tipo_producto_id == 1 ? 'curso diplomado' : 'curso normal';
        $name = Helper::formatFilename($file->getClientOriginalName());
        $path = $type. '/' . $course_id . '/'  . $class_id  . '/'  . 'class/';
        Storage::disk('s3')->put($path . $name, file_get_contents($file), 'public');
        $url = $path . $name;
        $video = new Video();
        $video->filename= $name;
        $video->path = $url;
        $video->videoable_type = 'test';
        $video->videoable_id = 0;
        $video->class_id = $class_id;
        $video->saved_time = 0;
        $video->save();
    }

    public static function storeReusableVideo($video_id, $class_id){
        $video_template = Video::findOrFail($video_id);
        $video = new Video();
        $video->filename = $video_template->filename;
        $video->path= $video_template->path;
        $video->videoable_type = 'test';
        $video->videoable_id = 0;
        $video->class_id = $class_id;
        $video->saved_time = 0;
        $video->save();
        return $video;
    }

    public static function deleteClassVideo($videos)
    {
        if (count($videos) > 0) {
            // Storage::disk('s3')->delete($video->first()->path);
            // $video->first()->delete();
            $video = $videos[0]; // Obtén el modelo de la colección
            $video->status = 0;
            $video->update();
        }
    }

    public static function updateClassVideo($file, $course_id, $class_id)
    {
        $course_type = Producto::where('id', $course_id)
            ->select('tipo_producto_id')
            ->first();

        $type = $course_type->tipo_producto_id == 1 ? 'curso diplomado' : 'curso normal';
        $video = Video::where('class_id', $class_id)->first();
        $name = Helper::formatFilename($file->getClientOriginalName());
        $path = $type. '/' . $course_id . '/'  . $class_id  . '/'  . 'class/';
        $url = $path . $name;
        if(!$video){
            $video = new Video();
            $video->filename= $name;
            $video->path = $url;
            $video->videoable_type = 'test';
            $video->videoable_id = 0;
            $video->class_id = $class_id;
            $video->saved_time = 0;
            $video->save();
        }else{
            $video->path = $url;
            $video->filename= $name;
            $video->videoable_type = 'test';
            $video->videoable_id = 0;
            $video->saved_time = 0;
            $video->update();
        }
        $video_path = $video->path ?? "no_path";
        if($video_path != "no_path"){
            Storage::disk('s3')->delete($video->path);
        }

        // $s3Client = new S3Client([
        //     'region' => env('AWS_DEFAULT_REGION'),
        //     'version' => 'latest'
        // ]);
        
        // // Use multipart upload
        // $source = fopen($file, 'rb');
        // $uploader = new S3MultipartUploader($s3Client, $source, [
        //     'bucket' => env('AWS_BUCKET'),
        //     'key' => file_get_contents($file),
        // ]);
        
        // try {
        //     $result = $uploader->upload();
        //     echo "Upload complete: {$result['ObjectURL']}\n";
        // } catch (MultipartUploadException $e) {
        //     echo $e->getMessage() . "\n";
        // }
         

        
        // $s3Client = new S3Client([
        //     'region' => env('AWS_DEFAULT_REGION'),
        //     'version' => '2006-03-01'
        // ]);
        
        // $bucket = env('AWS_BUCKET');
        // $key = file_get_contents($file);
        
        // // Using stream instead of file path
        // $source = fopen($file, 'rb');
        
        // $uploader = new ObjectUploader(
        //     $s3Client,
        //     $bucket,
        //     $key,
        //     $source
        // );
        
        // do {
        //     try {
        //         $result = $uploader->upload();
        //         if ($result["@metadata"]["statusCode"] == '200') {
        //             print('<p>File successfully uploaded to ' . $result["ObjectURL"] . '.</p>');
        //         }
        //         print($result);
        //     } catch (MultipartUploadException $e) {
        //         rewind($source);
        //         $uploader = new S3MultipartUploader($s3Client, $source, [
        //             'state' => $e->getState(),
        //         ]);
        //     }
        // } while (!isset($result));
        
        // fclose($source);
        Storage::disk('s3')->put($path . $name, fopen($file, 'rb'), 'public');
        // Storage::disk('s3')->put($path . $name, fopen($file, 'r+'), 'public');
        //incrementar post_max_size,upload_max_filesize,max_execution_time,memory_limit
    }

    public function courseType($course_id){
        $course_type = Producto::where('id', $course_id)
            ->select('tipo_producto_id')
            ->first();
        $type = $course_type->tipo_producto_id == 1 ? 'curso diplomado' : ($course_type->tipo_producto_id == 2 ? 'curso normal' : 'curso');
        return $type;
    }
}
