<?php

namespace App\Http\Controllers\api;

use App\Helpers\Helper;
use App\Http\Controllers\Controller;
use App\Models\Module;
use App\Models\Producto;
use App\Models\Video;
use Illuminate\Http\Request;
use App\Traits\ResponseFormat;
use Illuminate\Support\Facades\Storage;

class VideoController extends Controller
{
    use ResponseFormat;

    // public function updateStatus(Request $request)
    // {
    //     $video = Video::findOrFail($request->id);
    //     $video->status = 1;
    //     $video->update();
    // }

    public function streamVideo(Request $request)
    {
        $video = Video::join('class', 'videos.class_id', '=', 'class.id')
            ->join('modules', 'modules.id', '=', 'class.id_modules')
            ->where('class.slug', $request->slug)
            ->where('modules.id_courses', $request->product_id)
            ->select('videos.path')
            ->first();
        $path = "https://ipssoma-storage.s3.eu-west-1.amazonaws.com/" . $video->path;
        return $path;
    }

    public function getVideoIntro($slug)
    {
        $product = Producto::select('slug', 'id')->where('slug', $slug)->get()->first();
        $video = Module::join('class', 'modules.id', '=', 'class.id_modules')
            ->join('videos', 'class.id', '=', 'videos.class_id')
            ->where('modules.id_courses', $product->id)
            ->where('class.is_preview', 1)
            ->where('class.status', 1)
            ->select('videos.path')
            ->first();
        return "https://ipssoma-storage.s3.eu-west-1.amazonaws.com/" . $video->path;
    }

    // public function saveTime(Request $request)
    // {
    //     $video = Video::findOrFail($request->id);
    //     $video->saved_time = $request->time;
    //     $video->save();

    //     return $this->responseOk('', 'video time saved');
    // }

    // public function showTime(Request $request)
    // {
    //     $video = Video::findOrFail($request->id);
    //     $video_time = $video->saved_time;

    //     return $this->responseOk('', $video_time);
    // }

    // public static function storeClassVideo($file, $user_id, $course_id, $class_id)
    // {
    //     $name = Helper::formatFilename($file->getClientOriginalName());
    //     $path = 'courses/' . $user_id . '/' . $course_id . '/'  . $class_id  . '/'  . 'class/';
    //     Storage::disk('s3')->put($path . $name, file_get_contents($file), 'public');
    //     $url = $path . $name;
    //     $video = new Video();
    //     $video->filename= $name;
    //     $video->path = $url;
    //     $video->videoable_type = 'test';
    //     $video->videoable_id = 0;
    //     $video->class_id = $class_id;
    //     $video->saved_time = 0;
    //     $video->save();
    // }

    // public static function deleteClassVideo($video)
    // {
    //     if (count($video) > 0) {
    //         Storage::disk('s3')->delete($video->first()->path);
    //         $video->first()->delete();
    //     }
    // }

    // public static function updateClassVideo($file, $user_id, $course_id, $class_id)
    // {
    //     $video = Video::where('class_id', $class_id)->get()->first();
    //     $name = Helper::formatFilename($file->getClientOriginalName());
    //     $path = 'courses/' . $user_id . '/' . $course_id . '/' . $class_id . '/' . 'class/';
    //     Storage::disk('s3')->delete($video->path);
    //     Storage::disk('s3')->put($path . $name, file_get_contents($file), 'public');

    //     $url = $path . $name;
    //     $video->path = $url;
    //     $video->filename= $name;
    //     $video->videoable_type = 'test';
    //     $video->videoable_id = 0;
    //     $video->saved_time = 0;
    //     $video->update();
    // }
}
