<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class UserRequest3 extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'name' => ['required','min:2','max:50'],
            'email' => ['required','unique:users'],
            'password' => ['required','min:5','confirmed'],
            'phone' => ['required','min:1000000','integer'],
            'type_doc' => ['required','exists:document_types,id'],
            'number_doc' => ['required','min:00000000','unique:users'],
            'amount' => ['required']
        ];
    }

    public function messages(){
        return [
            'name.required' => 'Ingrese su nombre',
            'name.min' => 'Ingrese su nombre correctamente',
            'name.max' => 'Se sobrepasó la longitud máxima',
            'email.required' => 'Ingrese su correo electrónico',
            // 'email.email' => 'Su correo electrónico debe tener el formato correcto',
            'email.unique' => 'El correo electrónico ya fue registrado anteriormente',
            'password.required' => 'Ingrese una contraseña',
            'password.min' => 'La contraseña debe contener al menos 5 letras',
            'password.confirmed' => 'Las contraseñas no coincide',
            'phone.required' => 'Ingrese su teléfono',
            'phone.min' => 'El Teléfono debe contener 9 dígitos',
            'phone.integer' => 'El teléfono debe ser numérico',
            'type_doc.required' => 'Seleccione un tipo de documento',
            'type_doc.exists' => 'Seleccione un tipo de documento',
            'number_doc.required' => 'Ingrese su número de documento',
            // 'number_doc.integer' => 'El Número de documento solo debe contener números',
            'number_doc.min' => 'El Número de documento debe contener al menos 8 caracteres',
            'number_doc.unique' => 'El Número de documento ya ha sido registrado',
            'amount.required' => 'Ingrese el monto pagado'
        ];
    }
}
