<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Facturacion extends Model
{
    protected $table = 'facturacion';
    protected $with = ['producto'];
    protected $fillable = [
        'tipo_documento',
        'dni',
        'nombre',
        'apellido',
        'ruc',
        'empresa',
        'direccion',
        'departamento_id',
        'provincia_id',
        'distrito_id',
        'celular',
        'correo',
        'producto_id',
        'total',
    ];

    public function producto()
    {
        return $this->hasOne(Producto::class, 'id', 'producto_id');
    }
}
