<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Message extends Model
{
    use HasFactory;

    protected $table = 'message';

    protected $fillable = [
        'conversation_id',
        'api_id',
        'choices',
        'usage',
        'date_of_issue',
        'status',
        'emisor'
    ];
    
    protected $casts = [
        'choices' => 'json',
        'usage' => 'json',
    ];

    public function conversation()
    {
        return $this->belongsTo(Conversation::class, 'conversation_id');
    }
}
