<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Risk extends Model
{
    use HasFactory;
    protected $table = 'risks';
    protected $fillable = ['description'];

    public function iperc()
    {
        return $this->hasMany(IPERC::class, 'risks_id');
    }

    public function riskEvaluation()
    {
        return $this->hasMany(RiskEvaluation::class, 'risks_id');
    }
}
