<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateNewsTagsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('news_tags_detail', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('new_id');
            $table->unsignedBigInteger('tag_id');
            $table->timestamps();
            $table->foreign('new_id')
            ->references('id')->on('news')->onDelete('cascade');
            $table->foreign('tag_id')
            ->references('id')->on('tags')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('news_tags_detail');
    }
}
