<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateProductosTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('productos', function (Blueprint $table) {
            $table->id();
            $table->string('nombre',100);
            $table->longText('descripcion');
            $table->longText('objetivo');
            $table->longText('will_learn')->nullable();
            $table->longText('prev_knowledge')->nullable();
            $table->longText('course_for')->nullable();
            $table->double('precio');
            $table->string('portada_name')->nullable();
            $table->text('portada_url')->nullable();
            $table->tinyInteger('estado_publicacion')->default(0);
            $table->unsignedBigInteger('tipo_producto_id');
            $table->unsignedBigInteger('course_categories_id')->default(1);
            $table->timestamps();

            $table->foreign('tipo_producto_id')->references('id')->on('tipo_productos')
                ->onDelete('cascade');

            $table->foreign('course_categories_id')->references('id')->on('course_categories')
                ->onDelete('cascade');    
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('productos');
    }
}
