<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class RiskEvaluationSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        //
        DB::table('risk_evaluation')->insert([
            'risks_id' => 1,
            'type' => 'inherent',
            'index_a' => 1,
            'index_b' => 2,
            'index_c' => 1,
            'index_d' => 3,
            'probability' => 7,
            'severity' => 2,
            'ps' => 14,
            'NV' => 'M',
            'signification' => 1,
            'created_at' => now(),
            'updated_at' => now(),
        ]);

        DB::table('risk_evaluation')->insert([
            'risks_id' => 1,
            'type' => 'residual',
            'index_a' => 1,
            'index_b' => 0,
            'index_c' => 2,
            'index_d' => 1,
            'probability' => 4,
            'severity' => 1,
            'ps' => 4,
            'NV' => 'TR',
            'signification' => 1,
            'created_at' => now(),
            'updated_at' => now(),
        ]);
    }
}
