@extends('adminlte::page')
@section('title', "Editar Examen")
@section('content')
@section('content_header')
    {{-- google ads --}}
    <script async src="https://www.googletagmanager.com/gtag/js?id=AW-11111928634"></script>
    <script>
    window.dataLayer = window.dataLayer || [];
    function gtag(){dataLayer.push(arguments);}
    gtag('js', new Date());
    gtag('config', 'AW-11111928634');
    </script>
    {{-- google analytics --}}
    <script async src="https://www.googletagmanager.com/gtag/js?id=G-C4PSP030TR"></script>
    <script>
      window.dataLayer = window.dataLayer || [];
      function gtag(){dataLayer.push(arguments);}
      gtag('js', new Date());
      gtag('config', 'G-C4PSP030TR');
    </script>
@stop
@section('css')
    <link rel="stylesheet" href="{{asset('css/app.css')}}">
@endsection
    <div id="app">
        <div class="d-flex flex-row-reverse">
            @if($type == 1)
            <a class="btn btn-link" href="{{ route('exam-create', $course_id) }}">Regresar a Lista de Examenes</a>
            @elseif($type == 2)
            <a class="btn btn-link" href="{{ route('exam-module-create', $course_id) }}">Regresar a Lista de Examenes</a>
            @else
            <a class="btn btn-link" href="{{ route('exam-lesson-create', $course_id) }}">Regresar a Lista de Examenes</a>
            @endif
        </div>
        <div class="row">
            <div class="col-md-12 col-lg-12">
                <course-edit-exam :exam='@json($exam)'></course-edit-exam>
            </div>
        </div>
    </div>
@endsection
@section('js')
    <script src="{{asset('js/app.js?v=345443')}}"></script>
@endsection
