@extends('adminlte::page')
@section('title', "Editar Pregunta")
@section('css')
    <link rel="stylesheet" href="{{asset('css/app.css')}}">
@endsection
@section('content_header')
    {{-- google ads --}}
    <script async src="https://www.googletagmanager.com/gtag/js?id=AW-11111928634"></script>
    <script>
    window.dataLayer = window.dataLayer || [];
    function gtag(){dataLayer.push(arguments);}
    gtag('js', new Date());
    gtag('config', 'AW-11111928634');
    </script>
    {{-- google analytics --}}
    <script async src="https://www.googletagmanager.com/gtag/js?id=G-C4PSP030TR"></script>
    <script>
      window.dataLayer = window.dataLayer || [];
      function gtag(){dataLayer.push(arguments);}
      gtag('js', new Date());
      gtag('config', 'G-C4PSP030TR');
    </script>
@stop
@section('content')
    <div id="app">
        <div class="d-flex flex-row-reverse">
            <div class="d-flex flex-row-reverse">

                @if($type == 1)
                <a class="btn btn-link" href="{{ route('exam-edit', $exam->id) }}">Regresar a Lista de Preguntas</a>
                @elseif($type == 2)
                <a class="btn btn-link" href="{{ route('exam-module-edit', $exam->id) }}">Regresar a Lista de Preguntas</a>
                @else($type == 3)
                <a class="btn btn-link" href="{{ route('exam-lesson-edit', $exam->id) }}">Regresar a Lista de Preguntas</a>
                @endif

            </div>
        </div>
        <course-exam-question-details :exam='@json($exam)' :question='@json($question)' :question_types='@json($question_types)'></course-exam-question-details>
    </div>
@endsection
@section('js')
    <script src="{{asset('js/app.js?v=345443')}}"></script>
@endsection
