<?php

//COMENTARIO DE PRUEBA

use App\Http\Controllers\ProductPaymentController;
use App\Http\Controllers\Auth\RegisterController;
use Illuminate\Support\Facades\Route;
use Illuminate\Support\Facades\Auth;
use App\Http\Controllers\UsuariosController;
use App\Http\Controllers\DashboardController;
use App\Http\Controllers\GenerarController;
use App\Http\Controllers\ClientesCertificadosController;
use App\Http\Controllers\CertificadosController;
use App\Http\Controllers\FacturacionController;
use App\Http\Controllers\PagosPendientesController;
use App\Http\Controllers\ProductosController;
use App\Http\Controllers\CourseController;
use App\Http\Controllers\CourseGameController;
use App\Http\Controllers\CourseModuleController;
use App\Http\Controllers\DocumentTypeController;
use App\Http\Controllers\ModuleClassController;
use App\Http\Controllers\SSTClientController;
use App\Http\Controllers\IsoController;
use App\Http\Controllers\AlertController;
use App\Http\Controllers\QueryController;
use App\Http\Controllers\Auth\LoginController;
use App\Http\Controllers\BannerController;
use App\Http\Controllers\EventController;
use App\Http\Controllers\ClassResourceController;
use App\Http\Controllers\ExamController;
use App\Http\Controllers\ExamQuestionController;
use App\Http\Controllers\NewsController;
use App\Http\Controllers\OfferController;
use App\Http\Controllers\TagsController;
use Illuminate\Contracts\Session\Session;
use Illuminate\Support\Facades\Response;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::get('/', [LoginController::class, 'loginView'])->name('login.view');

Auth::routes();

//ruta del dashboard
Route::get('/dashboard', [DashboardController::class, 'index'])->name('dashboard');
Route::post('/login', [LoginController::class, 'loginMain'])->name('login.dash');

//link de invitación de vendedor
Route::get('/registrar/{id}', [UsuariosController::class, 'crearUsuario']);
Route::get('/user/{id}/view-classroom', [UsuariosController::class, 'viewClassroom']);
Route::get('/preview', [UsuariosController::class, 'preview']);
Route::post('/registrar-usuario', [RegisterController::class, 'create'])->name('usuario.registrar');
Route::get('/mostrar-curso/{id}', [RegisterController::class, 'mostrarCurso'])->name('mostrar.curso');
Route::post('/registrar/admin', [RegisterController::class, 'adminRegistraUsuario'])->name('register.admin');

//crear usuario sin vendedor
Route::post('/register', [RegisterController::class, 'createNoVendedor'])->name('register.create'); //nuevo usuario sin vendedor
Route::get('/register-index', [UsuariosController::class, 'crearUsuarioNoVendedor'])->name('register.index');

Route::group(['prefix' => '/user'], function () {
    Route::get('/{id}/info', [UsuariosController::class, 'info']);
});

//rutas del modulo de usuarios
Route::group(['prefix' => 'usuarios'], function () {
    Route::view('/', 'modules.usuarios')->name('usuarios');
    Route::post('/listar', [UsuariosController::class, 'index']);
    Route::get('/editar{id}', [UsuariosController::class, 'editar'])->name('usuario.editar');
    Route::put('/actualizar/{id}', [UsuariosController::class, 'actualizar'])->name('usuario.actualizar');
    Route::post('/eliminar', [UsuariosController::class, 'eliminar'])->name('usuario.eliminar');
    Route::get('/vendedor/{id}', [UsuariosController::class, 'usuarioVendedor']);
    Route::get('/verificar', [UsuariosController::class, 'verificarCompras']);
    Route::get('/cursos-comprados', [UsuariosController::class, 'cursosComprados']);
    Route::post('/extender-dias', [UsuariosController::class, 'extendDays'])->name('usuario.extenderdias');

    Route::group(['prefix' => '/vendedores'], function () {
        Route::view('/', 'modules.vendedores');
        Route::get('/listar', [UsuariosController::class, 'listarVendedores']);
        Route::get('/crear', [UsuariosController::class, 'crearVendedor'])->name('vendedor.crear');
        Route::post('/guardar', [UsuariosController::class, 'guardarVendedor'])->name('vendedor.guardar');
        Route::post('/actualizar', [UsuariosController::class, 'actualizarVendedor'])->name('vendedor.actualizar');
        Route::post('/estado/cambiar', [UsuariosController::class, 'cambiarEstado'])->name('vendedor.estado');
    });
    Route::group(['prefix' => '/profesores'], function () {
        Route::view('/', 'modules.profesores');
        Route::get('/listar', [UsuariosController::class, 'listarProfesores'])->name('profesor.view');
        Route::get('/crear', [UsuariosController::class, 'crearProfesor'])->name('profesor.crear');
        Route::post('/actualizar', [UsuariosController::class, 'actualizarProfesor'])->name('profesor.actualizar');
        Route::post('/guardar', [UsuariosController::class, 'guardarProfesor'])->name('profesor.guardar');
        Route::delete('/borrar/{id}', [UsuariosController::class, 'borrarProfesor'])->name('profesor.borrar');
    });
});

//ruta de Generar Certificados
// Route::get('/generar{id}', [GenerarController::class, 'generarCertificado'])->name('generar.certificado');
Route::get('/download{id}', [GenerarController::class, 'generarCertificado'])->name('download.certificado');

Route::group(['prefix' => 'alerts'], function () {
    Route::get('/', [AlertController::class, 'index'])->name('alerts');
    Route::post('/store', [AlertController::class, 'store'])->name('store.alert');
    Route::get('/list', [AlertController::class, 'list'])->name('store.list');
});
Route::group(['prefix' => 'news'], function () {
    Route::get('/', [NewsController::class, 'index'])->name('news');
    Route::get('/list', [NewsController::class, 'list'])->name('news.list');
    Route::post('/store', [NewsController::class, 'store'])->name('news.store');
    Route::patch('/change-status', [NewsController::class, 'changeStatus']);
    Route::post('/update', [NewsController::class, 'update']);
});
Route::group(['prefix' => 'tags'], function () {
    Route::get('/list', [TagsController::class, 'list'])->name('tags.list');
    Route::post('/store', [TagsController::class, 'store'])->name('tags.store');
});

Route::group(['prefix' => '/usuarios-invitados'], function(){
    Route::view('/', 'content.vendedor.vendedor_usuarios');
    Route::get('/list', [UsuariosController::class, 'invitedUsers']);
});

Route::group(['prefix' => '/clientes-sst'], function () {
    Route::view('/', 'content.clientesSST.clientes_sst')->name('clientesSST');
    Route::get('/list', [SSTClientController::class, 'listarClientesSST']);
    Route::view('/create', 'content.clientesSST.create')->name('clientesSST.create');
    Route::post('/save', [SSTClientController::class, 'guardarClienteSST']);
    Route::post('/update', [SSTClientController::class, 'actualizarClienteSST']);
    Route::delete('/delete/{id}', [SSTClientController::class, 'delete'])->name('clienteSST.delete');
});

Route::group(['prefix' => '/banners'], function(){
    Route::view('/', 'content.banners.banner-list')->name('banner.index');
    Route::get('/list', [BannerController::class, 'list']);
    Route::view('/create', 'content.banners.create')->name('banner.create');
    Route::post('/store', [BannerController::class, 'store']);
    Route::post('/update', [BannerController::class, 'update']);
    Route::patch('/change-status/{id}', [BannerController::class, 'changeStatus']);
});

Route::group(['prefix' => '/events'], function(){
    Route::view('/', 'content.events.event-list')->name('event.index');
    Route::get('/list', [EventController::class, 'list']);
    Route::view('/create', 'content.events.create')->name('event.create');
    Route::post('/store', [EventController::class, 'store']);
    Route::post('/update', [EventController::class, 'update']);
    Route::patch('/change-status/{id}', [EventController::class, 'changeStatus']);
});


//crud de productos
Route::group(['prefix' => 'productos'], function () {
    Route::get('/list', [ProductosController::class, 'index'])->name('product.index');
    Route::post('/create', [ProductosController::class, 'create'])->name('product.create');
    Route::get('/edit/{id}', [ProductosController::class, 'edit'])->name('product.edit');
    Route::post('/update', [ProductosController::class, 'store'])->name('product.store');
    Route::get('/delete/{id}', [ProductosController::class, 'delete'])->name('product.delete');
    Route::get('/tipo-producto', [ProductosController::class, 'tipoProducto'])->name('product.tipo');
    Route::get('/course-categories', [ProductosController::class, 'courseCategories'])->name('product.courseCategories');
    Route::get('/{id}/orders', [ProductosController::class, 'getOrders']);
    Route::patch('/change-order', [ProductosController::class, 'changeOrder']);
    Route::patch('/bloquear-acceso', [ProductosController::class, 'blockAccess']);
    Route::get('/all-courses', [ProductosController::class, 'allCoursesList']);
    Route::get('/{id}/all-classes-with-video', [ProductosController::class, 'allClassesWithVideoList']);

    Route::group(['prefix' => '/module'], function () {
        Route::post('/store', [CourseModuleController::class, 'store'])->name('module.store'); // action
        Route::get('/{id}/editModule', [CourseModuleController::class, 'editModule'])->name('module.editModule'); //view
        Route::put('/{id}/update', [CourseModuleController::class, 'update'])->name('module.update'); //action
        Route::delete('/{id}/delete', [CourseModuleController::class, 'delete'])->name('module.delete');
        Route::get('/{id}/list', [CourseModuleController::class, 'moduleList']);

        Route::group(['prefix' => '/class'], function () {
            Route::post('/{id}/save', [ModuleClassController::class, 'save'])->name('class.save');
            Route::delete('/{id}/delete', [ModuleClassController::class, 'delete'])->name('class.delete');
            Route::get('/{id}/classList', [ModuleClassController::class, 'getClassList'])->name('class.list');
            Route::get('/{id}/listObservations', [ModuleClassController::class, 'listObservations'])->name('class.listObservations');
            Route::get('/{id}/details', [ModuleClassController::class, 'getClassDetails'])->name('class.details');
            Route::post('/{id}/update', [ModuleClassController::class, 'update'])->name('class.update');
            Route::get('/{id}/get-resources', [ClassResourceController::class, 'getResources']);
            Route::get('/{id}/info', [ProductosController::class, 'classInfo']);
            Route::group(['prefix' => '/resource'], function(){
                Route::delete('/{id}/delete', [ClassResourceController::class, 'delete']);
            });
        });
    });

    Route::group(['prefix' => '/exam'], function () {
        Route::post('/store', [ExamController::class, 'store']);
        Route::get('{id}/create', [ExamController::class, 'create'])->name('exam-create');
        Route::get('/{id}/createModuleExam', [ExamController::class, 'createModuleExam'])->name('exam-module-create');
        Route::get('/{id}/createLessonExam', [ExamController::class, 'createLessonExam'])->name('exam-lesson-create');
        Route::get('/module/all', [ExamController::class, 'allModulesExam']);


        Route::get('/{id}/list', [ExamController::class, 'list']); // list exams by course id
        Route::get('/module/{id}/list', [ExamController::class, 'moduleList']); // list exams by module id
        Route::get('/lesson/{id}/list', [ExamController::class, 'lessonList']); // list exams by lesson id
        Route::get('/lesson/all', [ExamController::class, 'allLessonsExam']);

        Route::get('/edit/{id}', [ExamController::class, 'edit'])->name('exam-edit'); // edit exam by id
        Route::get('/module/edit/{id}', [ExamController::class, 'moduleEdit'])->name('exam-module-edit'); // edit exam by id
        Route::get('/lesson/edit/{id}', [ExamController::class, 'lessonEdit'])->name('exam-lesson-edit'); // edit exam by id
        Route::post('/lesson/destroy', [ExamController::class, 'lessonDestroy'])->name('exam-lesson-destroy'); // edit exam by id



        Route::post('/activate', [ExamController::class, 'activate']);
        Route::post('/destroy', [ExamController::class, 'destroy']);
        Route::get('/preview/{id}', [ExamController::class, 'preview']); // preview exam by id
        // Route::get('/rate', [UserExamHeaderController::class, 'index'])->name('exams.rate');
        // Route::get('/rate/{id}/list', [UserExamHeaderController::class, 'list'])->name('exams.list');
        // Route::get('/rate/{id}/detailList', [UserExamHeaderController::class, 'detailList'])->name('exams.detailList');
        // Route::post('/rate/update', [UserExamHeaderController::class, 'update'])->name('exams.rate.update');


        Route::group(['prefix' => '/question'], function () {
            Route::get('/{exam_id}/list', [ExamQuestionController::class, 'list']);
            Route::get('/{id}/get', [ExamQuestionController::class, 'get']);
            Route::get('/{id}/edit', [ExamQuestionController::class, 'edit'])->name('exam.question.edit');
            Route::post('/store', [ExamQuestionController::class, 'store']);
            Route::post('/options/store', [ExamQuestionController::class, 'optionsStore']); // save options from a question
            Route::delete('/{id}/delete', [ExamQuestionController::class, 'delete']);
        });
    });
});


//CRUD ISO
Route::group(['prefix' => 'isos'], function () {
    Route::get('/', [IsoController::class, 'index'])->name('isos.index');
    Route::get('/list', [IsoController::class, 'list'])->name('isos.list');
    Route::get('/create', [IsoController::class, 'create'])->name('isos.create');
    Route::post('/store', [IsoController::class, 'store'])->name('isos.store');
    Route::post('/update', [IsoController::class, 'update'])->name('isos.update');
    Route::delete('/delete/{id}', [IsoController::class, 'delete'])->name('isos.delete');
});

Route::group(['prefix' => 'course'], function () {
    Route::get('/', [CourseController::class, 'index'])->name('courses.index');
    Route::get('/create', [CourseController::class, 'create'])->name('courses.create');
    Route::get('/trash', [CourseController::class, 'trash'])->name('courses.trash');
    Route::get('/trash-list', [CourseController::class, 'listTrashCourses'])->name('courses.listTrashCourses');


    Route::post('/store', [CourseController::class, 'storeCourse'])->name('courses.store');
    Route::post('/update', [CourseController::class, 'update'])->name('courses.update');
    Route::put('/toggle-status/{id}', [CourseController::class, 'toggleStatus'])->name('courses.toggleStatus');
    Route::put('/restore/{id}', [CourseController::class, 'restore'])->name('courses.restore');
    Route::delete('/delete/{id}', [CourseController::class, 'delete'])->name('courses.delete');
    Route::get('list-all', [CourseController::class, 'listAll']);

    Route::get('/{id}/users', [CourseController::class, 'courseUsers']);
    Route::get('/{id}/users/get', [CourseController::class, 'getCourseUsers']);
    Route::delete('/payment/{id}/delete', [CourseController::class, 'deleteUser']);

    Route::group(['prefix' => 'game'], function () {
        Route::get('/{id}', [CourseGameController::class, 'index'])->name('game.index');
        Route::get('/{id}/list', [CourseGameController::class, 'list'])->name('game.list');
        Route::post('/store', [CourseGameController::class, 'store'])->name('game.store');
        Route::get('/edit/{id}', [CourseGameController::class, 'edit'])->name('game.edit');
    });
});

Route::group(['prefix' => 'payments'], function () {
    Route::view('/', 'content.payments.list');
    Route::post('/save', [ProductPaymentController::class, 'savePayment']);
    Route::get('/list', [ProductPaymentController::class, 'listPayments']);
    Route::group(['prefix' => '/product'], function () {
        Route::view('/', 'content.payments.payment-product-requests');
        Route::get('/requests', [ProductPaymentController::class, 'paymentCourseRequest']);
        Route::patch('/approve', [ProductPaymentController::class, 'approveCoursePayment']);
        Route::patch('/reject', [ProductPaymentController::class, 'rejectCoursePayment']);
    });
    Route::group(['prefix' => '/fractioned'], function(){
        Route::post('/pay', [ProductPaymentController::class, 'makePayment']);
    });
});

Route::group(['prefix' => '/offers'], function () {
    Route::view('/', 'content.offers.index')->name('offer.index');
    Route::view('/create', 'content.offers.create')->name('offer.create');
    Route::post('/save', [OfferController::class, 'saveOffer']);
    Route::get('/list', [OfferController::class, 'offerList']);
    Route::post('/update', [OfferController::class, 'updateOffer']);
    Route::get('/products/info', [OfferController::class, 'productsInfo']);
    Route::patch('/change-status/{id}', [OfferController::class, 'changeStatus']);
});
Route::group(['prefix' => '/queries'], function(){
    Route::view('/', 'content.queries.list');
    Route::get('/gift-pdf', [QueryController::class, 'listPdfRequests']);
});


//obtener tipo de documentos
Route::get('/document-types', [DocumentTypeController::class, 'getDocumentTypes']);
