<?php

namespace App\Http\Controllers\Auth;

use App\Traits\ResponseFormat;
use App\Http\Controllers\Controller;
use App\Models\Rol;
use App\Models\User;
use App\Providers\RouteServiceProvider;
use Carbon\Carbon;
use Illuminate\Foundation\Auth\AuthenticatesUsers;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;

class LoginController extends Controller
{
    use ResponseFormat;
    /*
    |-- ------------------------------------------------------------------------
    | Login Controller
    |--------------------------------------------------------------------------
    |
    | This controller handles authenticating users for the application and
    | redirecting them to your home screen. The controller uses a trait
    | to conveniently provide its functionality to your applications.
    |
    */

    use AuthenticatesUsers;

    /**
     * Where to redirect users after login.
     *
     * @var string
     */
    protected $redirectTo = RouteServiceProvider::HOME;

    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('guest')->except('logout');
    }

    public function loginApi(Request $request)
    {
        DB::beginTransaction();
        try {
            // $email = $request->email;
            // $password = $request->password;

            $login_credentials = [
                'email' => $request->email,
                'password' => $request->password,
            ];

            if (Auth::attempt($login_credentials)) {
                $user = User::where('email', $request->email)->first();
                // descomentar cuando se implemente laravel_permissions
                // $user_role = $user->getRoleNames();
                $user_role = Rol::findOrFail($user->roles_id);

                $tokenResult = $user->createToken('authToken');
                $token = $tokenResult->token;
                $token->expires_at = Carbon::now()->addHours(1);
                $token->save();
                DB::commit();

                return $this->responseOk(__('auth.correct_login'), [
                    'access_token' => $tokenResult->accessToken,
                    'token_type' => 'Bearer',
                    'user' => $user->toArray(),
                    'role' => $user_role->roles,
                ]);
            } else {
                return $this->responseUnauthorized();
            }
        } catch (\Throwable $e) {
            DB::rollBack();
            throw $e;
        }
    }

    public function loginApiForRedirect(Request $request)
    {
        DB::beginTransaction();
        try {
            $user = User::where("email", $request->email)->first();
            if ($request->password == $user->password){
                $user = User::where('email', $request->email)->first();
                // descomentar cuando se implemente laravel_permissions
                // $user_role = $user->getRoleNames();
                $user_role = Rol::findOrFail($user->roles_id);

                $tokenResult = $user->createToken('authToken');
                $token = $tokenResult->token;
                $token->expires_at = Carbon::now()->addHours(1);
                $token->save();
                DB::commit();

                return $this->responseOk(__('auth.correct_login'), [
                    'access_token' => $tokenResult->accessToken,
                    'token_type' => 'Bearer',
                    'user' => $user->toArray(),
                    'role' => $user_role->roles,
                ]);
            } else {
                return $this->responseUnauthorized();
            }
        } catch (\Throwable $e) {
            DB::rollBack();
            throw $e;
        }
    }

    public function loginMain(Request $request)
    {
        $this->validateLogin($request);

        // If the class is using the ThrottlesLogins trait, we can automatically throttle
        // the login attempts for this application. We'll key this by the username and
        // the IP address of the client making these requests into this application.
        $verify_data = false;
        if (method_exists($this, 'hasTooManyLoginAttempts') &&
            $this->hasTooManyLoginAttempts($request)) {
            $this->fireLockoutEvent($request);

            return $this->sendLockoutResponse($request);
        }
        if ($this->attemptLogin($request)) {
            if ($request->hasSession()) {
                $request->session()->put('auth.password_confirmed_at', time());
                $verify_data = true;
            }
            if($verify_data){
                $user = User::where('email', $request->email)->first();
                if(in_array($user->roles_id, [2,4])){
                    $this->logout($request);
                }
            }

            return $this->sendLoginResponse($request);
        }

        // If the login attempt was unsuccessful we will increment the number of attempts
        // to login and redirect the user back to the login form. Of course, when this
        // user surpasses their maximum number of attempts they will get locked out.
        $this->incrementLoginAttempts($request);

        return $this->sendFailedLoginResponse($request);
    }

    public function loginView(Request $request)
    {
        if ($request->hasSession()) {
            $this->logout($request);
            return view('auth.login');
        }else{
            return view('auth.login');
        }
    }
}
