<?php

namespace App\Http\Controllers;

use App\Helpers\Helper;
use App\Models\User;
use App\Models\Course;
use App\Models\Category;
use App\Models\BadgeDetail;
use App\Models\Badge;
use Illuminate\Http\Request;
use App\Http\Requests\CourseRequest;
use App\Http\Resources\CategoriesCollection;
use App\Models\Clas;
use App\Models\CourseConfiguration;
use App\Models\CourseLevel;
use App\Models\CourseObservation;
use App\Models\Module;
use App\Models\PurchasedCourse;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Storage;
use Nette\Utils\Json;
use App\Models\Notifications;
use App\Models\CourseRate;
use App\Models\Producto;
use App\Models\TipoProducto;
use App\Models\UserConfiguration;
use App\Http\Controllers\ModuleClassController;
use App\Models\CourseCategory;
use App\Models\ProductPayment;
use Illuminate\Support\Str;

class CourseController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
        // $this->middleware('ClientesCertificados');

        /* $this->middleware('can:courses.create')->only('create');
        $this->middleware('can:courses.index')->only('index', 'listCoursesProd');
        $this->middleware('can:courses.edit')->only('edit'); */
    }

    public function index()
    {
        $user = User::find(auth()->user()->id);
        /* $user = User::find(auth()->user()->id);
        $permission = $user->hasPermissionTo('courses.create'); */
        // return view('content.courses.index', compact('user', 'permission'));
        return view('content.courses.cursos', compact('user'));
    }

    public function trash()
    {
        return view('content.courses.trash');
    }

    public function listAll()
    {
        //cambiar condicion de estado de publicacion a 1 para el pase a produccion
        $products = Producto::where('estado_publicacion', 1)
            ->select('id', 'nombre', 'precio')->get();
        return $products;
    }

    public function listTrashCourses()
    {
        return  Producto::where('estado_publicacion', 3)
            ->select('id', 'nombre', 'precio', 'created_at')->get();
    }

    public function create()
    {
        $categories = TipoProducto::where('producto', 'not like', 'Oferta')->get();
        $courseCategories = CourseCategory::all();
        return view('content.courses.create', compact('categories', 'courseCategories'));
    }

    // public function review($id)
    // {
    //     $course = Course::where('courses.id', $id)->join('categories', 'courses.id_categories', '=', 'categories.id')->join('course_level', 'courses.course_level_id', '=', 'course_level.id')->select('courses.*', 'course_level.description as level', 'categories.name as category')->get()->first();
    //     $ready = $this->isReadyToPublish($course->id);
    //     return view('content.courses.verification.review', compact('course', 'ready'));
    // }

    // public function isReadyToPublish($id_course)
    // {
    //     $modules_ids = Course::find($id_course)->modules->pluck('id')->toArray();
    //     $lessons_status = [];
    //     foreach ($modules_ids as $module_id) {
    //         $status_of_lessons_from_module = Clas::where('id_modules', $module_id)->pluck('status')->toArray();
    //         array_push($lessons_status, $status_of_lessons_from_module);
    //     }
    //     $status_array = [];
    //     // Get status of all lessons in all modules
    //     foreach ($lessons_status as $status) {
    //         foreach ($status as $s) {
    //             array_push($status_array, $s);
    //         }
    //     }
    //     // si existe clase desaprobada o no ha sido revisada retorna false
    //     if (in_array(1, $status_array) || in_array(0, $status_array)) {
    //         return false;
    //     } else {
    //         return true;
    //     }
    // }




    public function storeCourse(Request $request)
    {
        $id = DB::select("SHOW TABLE STATUS LIKE 'productos'");
        $next_id = $id[0]->Auto_increment;
        $user = Auth::user();
        try {
            DB::beginTransaction();
            $course = new Producto();
            $course->tipo_producto_id = $request->id_categories;
            $course->course_categories_id = $request->course_categories_id;
            $course->nombre = $request->title;
            $course->slug = Str::slug($request->title);
            // $course->descripcion = $request->description;
            $cleanDescription = strip_tags($request->description);
            $course->descripcion = $cleanDescription;
            $course->precio = $request->price;
            $course->objetivo = $request->course_about;
            $course->will_learn = $request->will_learn;
            $course->prev_knowledge = $request->prev_knowledge;
            $course->course_for = $request->course_for;
            $course->months = $request->months;

            $course->estado_publicacion = 0;

            if ($request->hasFile('imageFile') || $request->hasFile('videoFile')) {
                $imageFile = $request->file('imageFile');
                $portada = Helper::formatFilename($imageFile->getClientOriginalName());
                $videoFile = $request->file('videoFile');
                $video = Helper::formatFilename($videoFile->getClientOriginalName());
                if ($request->id_categories == 1) {
                    $pathPortada = 'curso diplomado/' . $next_id . '/' . 'portada/';
                    $pathVideo = 'curso diplomado/' . $next_id . '/' . 'video/';
                } else if ($request->id_categories == 2) {
                    $pathPortada = 'curso normal/' . $next_id . '/' . 'portada/';
                    $pathVideo = 'curso normal/' . $next_id . '/' . 'video/';
                }
                Storage::disk('s3')->put($pathPortada . $portada, file_get_contents($imageFile), 'public');
                $course->portada_name = $portada;
                $course->portada_url = $pathPortada . $portada;
                Storage::disk('s3')->put($pathVideo . $video, file_get_contents($videoFile), 'public');
                $course->video_name = $video;
                $course->video_url = $pathVideo . $video;
            }else if ($request->hasFile('imageFile')) {
                $imageFile = $request->file('imageFile');
                $portada = Helper::formatFilename($imageFile->getClientOriginalName());
                if ($request->id_categories == 1) {
                    $path = 'curso diplomado/' . $next_id . '/' . 'portada/';
                } else if ($request->id_categories == 2) {
                    $path = 'curso normal/' . $next_id . '/' . 'portada/';
                }
                Storage::disk('s3')->put($path . $portada, file_get_contents($imageFile), 'public');
                $course->portada_name = $portada;
                $course->portada_url = $path . $portada;
                
            }else if ($request->hasFile('videoFile')) {
                $videoFile = $request->file('videoFile');
                $video = Helper::formatFilename($videoFile->getClientOriginalName());
                if ($request->id_categories == 1) {
                    $path = 'curso diplomado/' . $next_id . '/' . 'video/';
                } else if ($request->id_categories == 2) {
                    $path = 'curso normal/' . $next_id . '/' . 'video/';
                }
                Storage::disk('s3')->put($path . $video, file_get_contents($videoFile), 'public');
                $course->video_name = $video;
                $course->video_url = $path . $video;
            }
            

            if ($course->save()) {
                $response['status'] = 'ok';
            } else {
                $response['status']  = 'error';
            }
            echo json_encode($response);
            DB::commit();
        } catch (\Throwable $th) {
            DB::rollBack();
            throw $th;
        }
    }

    // public function courseList($id)
    // {
    //     $courses = Course::where('user_id', $id)->join('course_level', 'courses.course_level_id', '=', 'course_level.id')->select('courses.*', 'course_level.description as level')->orderBy('id', 'DESC')->get();
    //     echo json_encode($courses);
    // }

    // public function courseListVerification()
    // {
    //     $courses = Course::where('status', 1)->join('users', 'courses.user_id', '=', 'users.id')->select('courses.*', 'users.name')->get();
    //     echo json_encode($courses);
    // }

    // public function edit($id)
    // {
    //     $course = Course::where('id', $id)->join('course_level', 'courses.course_level_id', '=', 'course_level.id')->select('courses.*', 'course_level.description as level')->get()->first();
    //     echo json_encode($course);
    // }

    public function update(Request $request)
    {
        $course = Producto::find($request->id);
        try {
            DB::beginTransaction();

            $course->tipo_producto_id = $request->tipo_producto_id;
            $course->course_categories_id = $request->course_categories_id;
            $course->nombre = $request->nombre;
            $course->descripcion = $request->descripcion;
            $course->precio = $request->precio;
            $course->objetivo = $request->objetivo;
            $course->will_learn = $request->will_learn;
            $course->prev_knowledge = $request->prev_knowledge;
            $course->course_for = $request->course_for;
            $course->estado_publicacion = $request->estado_publicacion;
            $course->months = $request->months;

            if ($request->hasFile('imageFile') && $request->hasFile('videoFile')) {
                $newImageFile = $request->file('imageFile');

                $portada = Helper::formatFilename($newImageFile->getClientOriginalName());

                if ($request->tipo_producto_id == 1) {
                    $path = 'curso diplomado/' . $request->id . '/' . 'portada/';
                } else if ($request->tipo_producto_id == 2) {
                    $path = 'curso normal/' . $request->id . '/' . 'portada/';
                }
                if (Storage::disk('s3')->has($course->portada_url)) {
                    Storage::disk('s3')->delete($course->portada_url);
                }
                Storage::disk('s3')->put($path . $portada, file_get_contents($newImageFile), 'public');
                $course->portada_name = $portada;
                $course->portada_url = $path . $portada;
                $course->portada_url = $path . $portada;


                $newVideoFile = $request->file('videoFile');
                $video = Helper::formatFilename($newVideoFile->getClientOriginalName());

                if ($request->tipo_producto_id == 1) {
                    $path = 'curso diplomado/' . $request->id . '/' . 'video/';
                } else if ($request->tipo_producto_id == 2) {
                    $path = 'curso normal/' . $request->id . '/' . 'video/';
                }
                if (Storage::disk('s3')->has($course->video_url)) {
                    Storage::disk('s3')->delete($course->video_url);
                }
                Storage::disk('s3')->put($path . $video, file_get_contents($newVideoFile), 'public');
                $course->video_name = $video;
                $course->video_url = $path . $video;
            }
            else if ($request->hasFile('imageFile')) {
                $newImageFile = $request->file('imageFile');
                $portada = Helper::formatFilename($newImageFile->getClientOriginalName());

                if ($request->tipo_producto_id == 1) {
                    $path = 'curso diplomado/' . $request->id . '/' . 'portada/';
                } else if ($request->tipo_producto_id == 2) {
                    $path = 'curso normal/' . $request->id . '/' . 'portada/';
                }
                if (Storage::disk('s3')->has($course->portada_url)) {
                    Storage::disk('s3')->delete($course->portada_url);
                }
                Storage::disk('s3')->put($path . $portada, file_get_contents($newImageFile), 'public');
                $course->portada_name = $portada;
                $course->portada_url = $path . $portada;
            }
            else if ($request->hasFile('videoFile')) {
                $newVideoFile = $request->file('videoFile');
                $video = Helper::formatFilename($newVideoFile->getClientOriginalName());

                if ($request->tipo_producto_id == 1) {
                    $path = 'curso diplomado/' . $request->id . '/' . 'video/';
                } else if ($request->tipo_producto_id == 2) {
                    $path = 'curso normal/' . $request->id . '/' . 'video/';
                }
                if (Storage::disk('s3')->has($course->video_url)) {
                    Storage::disk('s3')->delete($course->video_url);
                }
                Storage::disk('s3')->put($path . $video, file_get_contents($newVideoFile), 'public');
                $course->video_name = $video;
                $course->video_url = $path . $video;
            }
            if ($course->update()) {
                $response['status'] = 'ok';
            } else {
                $response['status']  = 'error';
            }
            echo json_encode($response);
            DB::commit();
        } catch (\Throwable $th) {
            DB::rollBack();
            throw $th;
        }
    }

    // public function listCoursesProd()
    // {
    //     $user = User::find(auth()->user()->id);
    //     $data['course'] = $user->MyCourses()->get();
    //     $data['latests'] = Course::where('user_id', $user->id)->latest()->first();
    //     if (count($data['course']) == 0) {
    //         return ['error' => 'user without courses'];
    //     } else {
    //         return $data;
    //     }
    // }

    public function delete($id)
    {
        // Move to trash
        try {
            DB::beginTransaction();
            $course = Producto::findOrFail($id);
            $course->estado_publicacion = 3;
            if ($course->update()) {
                DB::commit();
                return response()->json(['status' => 'ok']);
            }
        } catch (\Throwable $th) {
            DB::rollBack();
            throw $th;
        }
        // $course = Producto::find($id);
        // $modules = Producto::find($id)->modules;
        // if (count($modules)) {
        //     foreach ($modules as $module) {
        //         CourseModuleController::delete($module->id);
        //     }
        // }
        // try {
        //     DB::beginTransaction();
        //     Storage::disk('s3')->delete($course->portada_url);
        //     if ($course->delete()) {
        //         $response['status'] = 'ok';
        //     } else {
        //         $response['status'] = 'error';
        //     }
        //     echo json_encode($response);
        //     DB::commit();
        // } catch (\Throwable $th) {
        //     DB::rollBack();
        //     throw $th;
        // }
    }

    public function toggleStatus($id)
    {
        try {
            DB::beginTransaction();
            $course = Producto::findOrFail($id);
            $course->estado_publicacion = ($course->estado_publicacion === 0) ? 1 : 0;
            if ($course->update()) {
                DB::commit();
                return response()->json(['status' => 'ok']);
            }
        } catch (\Throwable $th) {
            DB::rollBack();
            throw $th;
        }
    }

    public function restore($id)
    {
        try {
            DB::beginTransaction();
            $course = Producto::findOrFail($id);
            $course->estado_publicacion = 0;
            if ($course->update()) {
                DB::commit();
                return response()->json(['status' => 'ok']);
            }
        } catch (\Throwable $th) {
            DB::rollBack();
            throw $th;
        }
    }

    public function courseUsers($id){
        $course_name = Producto::where('id', $id)->pluck('nombre');
        $course_name = $course_name[0];
        return view('content.courses.users', compact('id', 'course_name'));
    }

    public function getCourseUsers($id){
        //sub admin
        $rol_id = auth()->user()->roles_id;
        if($rol_id == 6){
            $users = [];
        }else{
            $users = User::join('product_payments', 'users.id', '=', 'product_payments.user_id')
                ->join('purchased_products', 'product_payments.id', '=', 'purchased_products.payment_id')
                ->select('users.name', 'users.id', 'purchased_products.created_at', 'product_payments.id as payment_id')
                ->where('product_payments.status', 1)
                ->where('purchased_products.product_id', $id)
                ->get();
        }
        return $users;
    }

    public function deleteUser($payment_id){
        $payment = ProductPayment::findOrFail($payment_id);
        $payment->delete();
    }
    // public function userCourses($user_id)
    // {
    //     $courses = Course::where('user_id', $user_id)->join('course_level', 'courses.course_level_id', '=', 'course_level.id')->select('courses.*', 'course_level.description as level')->get();
    //     return $courses;
    // }

    // public function modulesList($course_id)
    // {
    //     $modules = Course::find($course_id)->modules;
    //     echo json_encode($modules);
    // }

    // public function verifyIsHasModules($course_id)
    // {
    //     $modules = Module::where('id_courses', $course_id)->get();
    //     if (count($modules) > 0) {
    //         $first_class = Clas::where('id_modules', $modules[0]->id)->get();
    //         if (count($first_class) > 0) {
    //             return true;
    //         }
    //     }
    //     return false;
    // }

    // public function prueba(){
    //     $signatureConfig = UserConfiguration::where('user_id', 2)
    //                     ->where('configuration_id', 2)->exists();
    //                 $templateConfig = UserConfiguration::where('user_id', 5)
    //                     ->where('configuration_id', 1)->exists();
    //                 $config = $signatureConfig && $templateConfig ? true : false;
    //                 return $templateConfig;
    // }

    // public function sendRequest($id)
    // {
    //     try {
    //         DB::beginTransaction();
    //         $course = Course::findOrFail($id);
    //         $hasModules = $this->verifyIsHasModules($id);

    //         if ($hasModules == true) {
    //             $coursIsConfig = CourseConfiguration::where('course_id', $id)->exists();
    //             if ($coursIsConfig) {
    //                 //condicion para evaluar firma
    //                 $signatureConfig = UserConfiguration::where('user_id', $course->user_id)
    //                     ->where('configuration_id', 2)->count();
    //                 $templateConfig = UserConfiguration::where('user_id', $course->user_id)
    //                     ->where('configuration_id', 1)->count();
    //                 $config = $signatureConfig > 0 && $templateConfig > 0 ? true : false;
    //                 if($config){
    //                     if ($course->status === 0 || $course->status === 3 || $course->status === 4) {
    //                         $course->status = 1;
    //                         if ($course->update()) {
    //                             $adminList = User::where('id_account_type', 1)->get();
    //                             foreach ($adminList as $admin) {
    //                                 $title = 'Curso pendiente a revisar';
    //                                 $body = "Tiene pendiente revisar $course->title";
    //                                 $this->notification($admin->id, $title, $body);
    //                             }
    //                             $response = 'ok';
    //                         } else {
    //                             $response  = 'error';
    //                         }
    //                     } else {
    //                         $response = 'request';
    //                     }
    //                 }else{
    //                     $response = 'signaturetemplate';
    //                 }
    //             } else {
    //                 $response = 'misconfigured';
    //             }
    //         } else {
    //             $response = 'empty';
    //         }
    //         echo json_encode($response);
    //         DB::commit();
    //     } catch (\Throwable $th) {
    //         DB::rollBack();
    //         throw $th;
    //     }
    // }

    // public function categoriesList()
    // {
    //     $categories = Category::all();
    //     return $categories;
    // }

    // public function levelsList()
    // {
    //     $levels = CourseLevel::all();
    //     return $levels;
    // }

    // public function subscribers()
    // {
    //     $id = auth()->user()->id;
    //     $courses = Course::where('user_id', $id)->select('id', 'id_categories', 'title', 'description', 'url_portada', 'portada')->get();
    //     $path = 'https://crm-storage-user.s3.eu-west-1.amazonaws.com/';

    //     $shareComponent = \Share::page('http://promolider.xyz/login')->facebook()
    //         ->twitter()
    //         ->linkedin()
    //         ->telegram()
    //         ->whatsapp()
    //         ->reddit();


    //     return view('content.courses.subscriber.index', compact('courses', 'path', 'shareComponent'));
    // }

    // public function subscribersList($course_id)
    // {
    //     $users = [];
    //     $subscriber = PurchasedCourse::where('course_id', $course_id)->get();
    //     foreach ($subscriber as $index => $value) {
    //         $user = User::where('id', $value->user_id)->get()->first();
    //         array_push($users, $user);
    //     }

    //     echo json_encode($users);
    // }

    // public function verification()
    // {
    //     $user = User::find(auth()->user()->id);
    //     return view('content.courses.verification.index', compact('user'));
    // }

    // public function configureCertificate($course_id)
    // {
    //     $course = Course::select('id', 'title')->where('id', $course_id)->get()->first();
    //     $courseConfig= CourseConfiguration::where('id', $course_id)->get()->first();
    //     return view('content.courses.certificate.index', compact('course'));
    // }
}
