<?php

namespace App\Http\Controllers\api;

use App\Http\Controllers\Controller;
use App\Models\Offer;
use App\Models\Producto;
use App\Models\ProductPayment;
use Illuminate\Http\Request;

class OfferController extends Controller
{
    public function list(){
        $offer_purchased_ids = ProductPayment::where('product_type', 3)
            ->where('status', 1)
            ->where('user_id', auth()->user()->id)
            ->pluck('product_id');

        $offers = Offer::select('id', 'name as nombre', 'price as precio', 'slug', 'portada_url')
            ->whereNotIn('id', $offer_purchased_ids)
            ->where('status', 1)
            ->get();
        return $offers;
    }

    public function offerInfo(Request $request){
        $offer = Offer::where('slug', $request->slug)
            ->select('id', 'name', 'products', 'price', 'portada_url')
            ->first();
        $products = [];
        $offers = json_decode($offer->products, true);
        foreach ($offers as $product_id) {
            $product = Producto::where('id', $product_id)
                ->select('nombre', 'slug', 'id', 'tipo_producto_id')
                ->first();
            array_push($products, $product);
        }
        $data = array(
            "offer_info" => $offer,
            "products_offer" => $products,
        );
        return $data;
    }

    public function offerDetails(Request $request){
        $offer = Offer::where('slug', $request->slug)
            ->select('id', 'name as nombre', 'price as precio', 'portada_url')
            ->first();
        return $offer;
    }
}
