<?php

namespace App\Http\Controllers\api;

use App\Http\Controllers\Controller;
use App\Models\Clas;
use App\Models\Producto;
use Illuminate\Http\Request;

class ProductClassController extends Controller
{
    public function classList($slug){
        $classList = Clas::where('slug', 'like', $slug)->where('status', 1)
            ->first();
        return $classList;
    }

    public function searchProductInfo($productSlug, $slug){
        if($slug == "empty slug"){
            $product = Producto::where('slug', $productSlug)
                ->first();
        }else{
            $product = Producto::join('modules', 'productos.id', '=', 'modules.id_courses')
                ->join('class', 'modules.id', '=', 'class.id_modules')
                ->where('productos.slug', $productSlug)
                ->where('class.slug', 'like', $slug)
                ->select('productos.id', 'productos.slug', 'tipo_producto_id', 'class.id as class_id', 'productos.nombre')
                ->first();
        }
        return $product;
    }

    public function getLinks($slug_product, $slug_class){
        $links = Producto::join('modules', 'productos.id', '=', 'modules.id_courses')
            ->join('class', 'modules.id', '=', 'class.id_modules')
            ->where('productos.slug', 'like', $slug_product)
            ->where('class.slug', 'like', $slug_class)
            ->select('class.external_links')
            ->first();
        return $links;
    }

    public function classInfo($slug){
        $class = Clas::where('slug', $slug)->where('status', 1)->first();
        return $class;
    }
}
