<?php

namespace App\Http\Controllers;

use App\Models\Iso;
use App\Http\Requests\StoreIsoRequest;
use App\Http\Requests\UpdateIsoRequest;
use App\Models\User;
use Illuminate\Support\Facades\DB;
use App\Helpers\Helper;
use Illuminate\Support\Facades\Storage;
use Illuminate\Http\Request;

class IsoController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */

    public function __construct()
    {
        $this->middleware('auth');
    }

    public function index()
    {
        $user = User::find(auth()->user()->id);
        return view('content.isos.index', compact('user'));
    }

    public function list()
    {
        $prod = Iso::get();
        return $prod;
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('content.isos.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \App\Http\Requests\StoreIsoRequest  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $id = DB::select("SHOW TABLE STATUS LIKE 'isos'");
        $next_id = $id[0]->Auto_increment;
        try {
            DB::beginTransaction();
            $course = new Iso();
            $course->name = $request->name;
            $course->intro = $request->intro;
            $course->time_obtaining = $request->time_obtaining;
            $course->time_validity = $request->time_validity;
            $course->steps_implementation = $request->steps_implementation;
            $course->benefits = $request->benefits;
        
            if ($request->hasFile('file')) {
                $newfile = $request->file('file');
                $portada = Helper::formatFilename($newfile->getClientOriginalName());
                $path = 'static/' . $next_id . 'cover';
                Storage::disk('s3')->put($path . $portada, file_get_contents($newfile), 'public');
                $course->cover_name = $portada;
                $course->url_image_cover = $path . $portada;
            }

            if ($request->hasFile('file2')) {
                $newfile = $request->file('file2');
                $portada = Helper::formatFilename($newfile->getClientOriginalName());
                $path = 'static/' . $next_id . 'page';
                Storage::disk('s3')->put($path . $portada, file_get_contents($newfile), 'public');
                $course->page_name = $portada;
                $course->url_image_page = $path . $portada;
            }

            if ($course->save()) {
                $response['status'] = 'ok';
            } else {
                $response['status']  = 'error';
            }
            echo json_encode($response);
            DB::commit();
        } catch (\Throwable $th) {
            DB::rollBack();
            throw $th;
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Iso  $iso
     * @return \Illuminate\Http\Response
     */
    public function show(Iso $iso)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Iso  $iso
     * @return \Illuminate\Http\Response
     */
    public function edit(Iso $iso)
    {
        //
    }

    public function update(Request $request)
    {
        $course = Iso::find($request->id);
        try {
            DB::beginTransaction();

            $course->name = $request->name;
            $course->intro = $request->intro;
            $course->time_obtaining = $request->time_obtaining;
            $course->time_validity = $request->time_validity;
            $course->steps_implementation = $request->steps_implementation;
            $course->benefits = $request->benefits;

            if ($request->hasFile('file')) {
                $newfile = $request->file('file');
                $portada = Helper::formatFilename($newfile->getClientOriginalName());
                $path = 'static/' . $request->id . 'cover';
               
                if(Storage::disk('s3')->has($course->url_image_cover)){
                    Storage::disk('s3')->delete($course->url_image_cover);
                }
                Storage::disk('s3')->put($path . $portada, file_get_contents($newfile), 'public');
                $course->cover_name = $portada;
                $course->url_image_cover = $path . $portada;
            }

            if ($request->hasFile('file2')) {
                $newfile = $request->file('file2');
                $portada = Helper::formatFilename($newfile->getClientOriginalName());
                $path = 'static/' . $request->id . 'page';
               
                if(Storage::disk('s3')->has($course->url_image_page)){
                    Storage::disk('s3')->delete($course->url_image_page);
                }
                Storage::disk('s3')->put($path . $portada, file_get_contents($newfile), 'public');
                $course->page_name = $portada;
                $course->url_image_page = $path . $portada;
            }

            if ($course->update()) {
                $response['status'] = 'ok';
            } else {
                $response['status']  = 'error';
            }
            echo json_encode($response);
            DB::commit();
        } catch (\Throwable $th) {
            DB::rollBack();
            throw $th;
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Iso  $iso
     * @return \Illuminate\Http\Response
     */
    public function destroy(Iso $iso)
    {
        //
    }

    public function delete($id)
    {
        $course = Iso::find($id);
        try {
            DB::beginTransaction();

            Storage::disk('s3')->delete($course->url_image_cover);
            Storage::disk('s3')->delete($course->url_image_page);

            if ($course->delete()) {
                $response['status'] = 'ok';
            } else {
                $response['status'] = 'error';
            }
            echo json_encode($response);
            DB::commit();
        } catch (\Throwable $th) {
            DB::rollBack();
            throw $th;
        }
    }
}
