<?php

namespace App\Http\Controllers\api;

use App\Http\Controllers\Controller;
use App\Models\ClassResource;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Storage;

class ClassResourceController extends Controller
{
    public function showResources(Request $request)
    {
        $resources = ClassResource::join('class', 'class_resources.class_id', '=', 'class.id')
            ->where('class.slug', $request->slug)
            ->select('class_resources.filename', 'class_resources.resource_file', 'class_resources.id')
            ->get();
        return $resources;
    }

    public function downloadResources(Request $request)
    {
        $resource = ClassResource::findOrFail($request->id);
        return Storage::disk('s3')->download($resource->resource_file);
    }
}
