<?php

namespace App\Http\Controllers\api;

use Illuminate\Http\Request;
use App\Models\User;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Validator;
use App\Models\DocumentType;
use App\Models\Country;
use Illuminate\Support\Facades\Hash;
use App\Http\Controllers\Controller;
use App\Mail\ContactarUsuarioMailable;
use App\Mail\EmailRecoveryMailable;
use App\Mail\RegisterMailableAlone;
use App\Mail\RegisterMailableAloneAdmin;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Mail;


class UsuariosController extends Controller
{

    protected function validator(array $data)
    {
        return Validator::make($data, [
            'name' => ['required', 'string', 'max:255'],
            'email' => ['required', 'string', 'email', 'max:255', 'unique:users'],
            'phone' => ['required', 'string', 'max:9'],
            'permissions[]',
            'rol' => ['required', 'integer'],
        ]);
    }

    public function registerAcademyUser(Request $request)
    {
        $resp = $this->validation($request);
        if ($resp === 'validated') {
            try {
              
                DB::beginTransaction();
                $cliente = new User();
                $cliente->name = $request->name;
                $cliente->password = Hash::make($request->password);
                $cliente->email = $request->email;
                $cliente->phone = $request->phone;
                $cliente->doc_type_id = $request->doc_type_id;
                $cliente->number_doc = $request->number_doc;
                $cliente->country = $request->country;
                $cliente->birthday = $request->birthday;
                $cliente->roles_id = 2;
                
                if ($cliente->save()) {


                    $data = (object) array('email' => $request->email, 'username' => $request->name, 'password' => $request->password);
                    $content = new RegisterMailableAlone($data);

                    Mail::to($request->email)
                        ->cc($request->email)
                        ->bcc($request->email)
                        ->send($content);


                    $data2 = (object) array('username' => $request->name, 'email' => $request->email);
                    $content2 = new RegisterMailableAloneAdmin($data2);

                    Mail::to('2402gladyslujan@gmail.com')
                        ->cc($request->email)
                        ->bcc($request->email)
                        ->send($content2);

                    DB::commit();
                    return response()->json([
                        'status' => 'success',
                        'message' => 'Usuario registrado correctamente',
                        'data' => $cliente
                    ], 200);
                } else {
                    DB::rollBack();
                    return response()->json([
                        'status' => 'error',
                        'message' => 'Error al registrar el usuario',
                        'data' => null
                    ], 500);
                }
            } catch (\Throwable $th) {
                DB::rollBack();
                throw $th;
            }
        } else {
           
            return response()->json([
                'status' => 'error',
                'message' => $resp,
                'data' => null
            ], 500);
        }
    }

    public function sendRecoveryEmail(Request $request)
    {
        $codes = User::select('codigo_recuperacion')->get();
        $codes = $codes->toArray();

        $user = User::where('email', $request->email)->get()->first();

        if ($user == null) {
            return "!Correo no registrado!";
        }

        $i = 0;
        do {
            $rand = rand(10000, 99999);

            if (in_array($rand, $codes) != true) {
                $user->codigo_recuperacion = $rand;
                $i = 1;
            }
        } while ($i == 0);

        $user->intentos = 0;
        $user->save();
        $data = (object) array('username' => $user->name, 'password' => $rand);
        $content = new EmailRecoveryMailable($data);

        Mail::to($user->email)
            ->cc($user->email)
            ->bcc($user->email)
            ->send($content);

        return "!Se ha enviado el correo de recuperación!";
    }

    public function recoveryPassword(Request $request)
    {
        $user = User::where('email', $request->email)->get()->first();
        if ($user == null) {
            return "El correo no está registrado";
        }
        if ($request->code == $user->codigo_recuperacion) {
            $user->codigo_recuperacion = null;
            $user->password = Hash::make($request->password);
            $user->save();
            return "Contraseña reestablecida";
        } else {
            if ($user->intentos < 2) {
                $user->intentos++;
                $user->save();
                return "Código de recuperación incorrecto, intentos restantes: " . (3 - $user->intentos);
            } else {
                return "Ha alcanzado el máximo de intentos, por favor , vuelva a realizar el proceso de recuperación de contraseña desde el aula virtual";
            }
        }
    }

    public function validation($request)
    {
        $response = 'validated';
        $obj = User::where('number_doc', $request->number_doc)->exists();
        $obj2 = User::where('email', $request->email)->exists();

        if ($obj) {
            $response = 'Este numero de docuemento ya ha sido registrado';
        }
        if ($obj2) {
            $response = 'Este email ya ha sido registrado';
        }
        if ($obj && $obj2) {
            $response = 'Este email y numero de documento ya fueron registrados';
        }
        return $response;
    }

    public function listDocumentType()
    {
        $obj = DocumentType::select('id', 'name')->get();
        return $obj;
    }

    public function listCountry()
    {
        $obj = Country::select('id', 'name')->get();
        return $obj;
    }

    public function update(Request $request)
    {
        $user = User::findOrFail($request->id);
        $user->name = $request->name;
        $user->phone = $request->phone;
        $user->email = $request->email;
        $user->doc_type_id = $request->doc_type_id;
        $user->number_doc = $request->number_doc;
        $user->update();
    }

    public function verifyUniqueEmail(Request $request)
    {
        $isUsed = User::where('email', $request->new_email)->exists();
        return $isUsed;
    }

    public function contactoVendedor()
    {
        $data = User::join('seller_links', 'users.id', 'seller_links.user_id')
            ->where('users.roles_id', 3)
            ->where('seller_links.status', 1)
            ->select('users.id', 'users.name', 'users.phone')
            ->get();
        return $data;
    }

    public function changePassword(Request $request)
    {
        $user = User::findOrFail(auth()->user()->id);
        if (Hash::check($request->actual_pass, $user->password)) {
            $user->password = Hash::make($request->new_pass);
            $user->update();
            return "Cambio de contraseña exitoso";
        } else {
            return "Ingrese su contraseña actual correctamente";
        }
    }

    public function userInfo()
    {
        $user = User::where('id', auth()->user()->id)
            ->select('id', 'name', 'email', 'phone', 'doc_type_id', 'number_doc')
            ->first();
        return $user;
    }

    public function contactarusuario(Request $request)
    {
        $data = (object) array('username' => $request->username,'numero' => $request->numero, 'email' => $request->email);
        $content = new ContactarUsuarioMailable($data);

        Mail::to('2402gladyslujan@gmail.com')
            ->cc($request->email)
            ->bcc($request->email)
            ->send($content);

        return "!Se han enviado sus datos, un encargado de IPSSOMA se pondrá en contacto con usted!";
    }
}
