<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use App\Models\User;


class NewsPermission
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */
    public function handle(Request $request, Closure $next)
    {
        $authId = auth::user()->id;
        $user = User::find($authId);
        $permiso = '5';

        if (strlen(strstr($user->permissions, $permiso)) > 0) {
            return $next($request);
        } else {
            return redirect('/dashboard');
        }
    }
}
