<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class RegisterMailableAloneAdmin extends Mailable
{
    use Queueable, SerializesModels;

    public $subject = 'Solicitud de Acceso';
    public $data;
    /**
     * Create a new message instance.
     *
     * @return void
     */
    public function __construct($data)
    {
        $this->data = $data;
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        return $this->from(env('MAIL_USERNAME'), 'IPSSOMA org')
                ->subject('Registro en IPSSOMA')
                ->view('emails.user_registered_alone_admin');
    }
}
