<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ClientesCertificados extends Model
{
    use HasFactory;

    protected $table = 'clientes_certificados';
    protected $with = ['pagos'];
    protected $fillable = [
        'id',
        'tipo_doc',
        'nro_doc',
        'nombres',
        'apellidos',
        'nombre_certificado',
        'codigo_certificado',
        'url',
        'user_old',
    ];

    public function scopeBuscarpor($query, $tipo, $texto)
    {
        if (($tipo) && ($texto)) {
            return $query->where($tipo, 'like', "%$texto%");
        }
    }

    function pagos()
    {
        return $this->hasOne(Pagos::class, 'cliente_id');
    }
}
