<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class WorkPositionSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        //
        $positions = [
            'Operario',
            'Supervisor',
            'Gerente', 
            'Técnico',
            // Agrega más posiciones según sea necesario
        ];

        // Iterar sobre cada posición laboral y crear un registro en la tabla 'work_positions'
        foreach ($positions as $position) {
            DB::table('work_positions')->insert([
                'name' => $position,
                'created_at' => now(),
                'updated_at' => now(),
            ]);
        }
    }
}
