require('./bootstrap');

import { createApp } from 'vue';

import ElementPlus from 'element-plus'
import * as ElementPlusIconsVue from '@element-plus/icons-vue'
import "element-plus/dist/index.css";
import es from 'element-plus/dist/locale/es.mjs'

import AddProduct from './components/ExampleComponent.vue';
import CoursesTable from './components/course/coursesTable.vue';
import ListaVendores from './components/Vendedores/ListaVendedores.vue';
import CoursesCreate from './components/course/CoursesCreate.vue';
import CoursesModuleList from './components/course/modules/CourseModuleList';
import ModuleCreateExam from './components/course/exam/module/createExam.vue';
import LessonCreateExam from './components/course/exam/lesson/createExam.vue';

import CoursesGamification from './components/course/gamification/index.vue';

import ListaUsuarios from './components/Usuarios/ListaUsuarios.vue';
import ClientesSst from './components/clientesSST/index.vue';
import CrearClienteSST from './components/clientesSST/create.vue';
import IsosTable from './components/iso/isosTable.vue';
import IsosCreate from './components/iso/isosCreate.vue';
import PaymentList from './components/payments/list.vue';
import AlertIPSSOMA from './components/alert/list.vue';
import News from './components/news/list.vue';
import ProfesoresTable from './components/profesores/profesoresTable.vue';
import ProfesoresCreate from './components/profesores/profesoresCreate.vue';
import CreateExam from './components/course/exam/createExam.vue';
import EditExam from './components/course/exam/editExam.vue';
import DetaiQuestion from './components/course/exam/detailQuestion.vue';
import ProductRequest from './components/payments/ProductRequests.vue';
import OfferList from './components/offers/OfferList.vue';
import OfferCreate from './components/offers/Create.vue';
import FormularioRegistro from './components/Registro.vue';
import FormularioHeader from './components/header.vue';
import FormularioFooter from './components/footer.vue';
import CourseTrash from './components/course/trashList.vue';
import BannersList from './components/banners/list.vue';
import BannerCreate from './components/banners/create.vue';
import EventsList from './components/events/list.vue';
import EventsCreate from './components/events/create.vue';
import CourseUsers from './components/course/users.vue';
import VendedorUsuarios from './components/Vendedores/vendedorUsuarios.vue';
import RegistroAdmin from './components/Usuarios/Registro.vue';
import QueryList from './components/queries/list.vue';
// import $ from "expose-loader?exposes=$,jQuery!jquery";

const app = createApp({});

app.use(ElementPlus, {
    locale: es,
});
for (const [key, component] of Object.entries(ElementPlusIconsVue)) {
    app.component(key, component)
};
app.component('example-component', AddProduct);
app.component('courses-table', CoursesTable);
app.component('course-module-list', CoursesModuleList);
app.component('module-create-exam', ModuleCreateExam);
app.component('lesson-create-exam', LessonCreateExam);
app.component('lista-vendedores', ListaVendores);
app.component('course-create', CoursesCreate);
app.component('lista-usuarios', ListaUsuarios);
app.component('clientes-sst', ClientesSst);
app.component('crear-cliente-sst', CrearClienteSST);
app.component('isos-table', IsosTable);
app.component('isos-create', IsosCreate);
app.component('payment-list', PaymentList);
app.component('alert-ipssoma', AlertIPSSOMA);
app.component('news', News);
app.component('profesores-table', ProfesoresTable);
app.component('profesores-create', ProfesoresCreate);

app.component('course-gamification', CoursesGamification);

app.component('course-create-exam', CreateExam);
app.component('course-edit-exam', EditExam);
app.component('course-exam-question-details', DetaiQuestion);
app.component('product-request', ProductRequest);
app.component('offer-list', OfferList);
app.component('offer-create', OfferCreate);
app.component('course-trash', CourseTrash);

app.component('formulario-registro', FormularioRegistro);
app.component('formulario-header', FormularioHeader);
app.component('formulario-footer', FormularioFooter);
app.component('banners-list', BannersList);
app.component('banner-create', BannerCreate);
app.component('events-list', EventsList);
app.component('events-create', EventsCreate);
app.component('course-users', CourseUsers);
app.component('vendedor-usuarios', VendedorUsuarios);
app.component('registro-admin', RegistroAdmin);
app.component('query-list', QueryList);


app.mount("#app")

