<?php

use App\Http\Controllers\Auth\LoginController;
use App\Http\Controllers\api\ProductoController;
use App\Http\Controllers\api\QueryController;
use App\Http\Controllers\api\SSTClientController;
use App\Http\Controllers\api\VideoController;
use App\Http\Controllers\api\IsoController;
use App\Http\Controllers\api\AlertController;
use App\Http\Controllers\api\BannerController;
use App\Http\Controllers\api\EventController;
use App\Http\Controllers\api\ClassResourceController;
use App\Http\Controllers\api\ExamController;
use App\Http\Controllers\api\profesoresController;
use App\Http\Controllers\api\ProductClassController;
use App\Http\Controllers\api\ProductPaymentController;
use App\Http\Controllers\api\UsuariosController;
use App\Http\Controllers\api\CountryController;
use App\Http\Controllers\api\OfferController;
use App\Http\Controllers\api\NewsController;
use App\Http\Controllers\api\PurchasedProductController;
use App\Http\Controllers\api\ChatController;
use App\Http\Controllers\api\ProcessController;
use App\Http\Controllers\api\DangerController;
use App\Http\Controllers\api\PlaceController;
use App\Http\Controllers\api\RiskController;
use App\Http\Controllers\api\TaskController;
use App\Http\Controllers\api\WorkPositionController;
use App\Http\Controllers\api\RiskEvaluationController;
use App\Http\Controllers\api\IPERCController;
use App\Http\Controllers\api\OperationalControlController;
use App\Http\Controllers\api\ConsequenceController;
use App\Http\Controllers\api\MatrixController;
use Illuminate\Support\Facades\Route;

Route::group(['prefix' => '/v1'], function () {
            Route::get('/course/exam', [ProductoController::class, 'exam']);
            Route::group(['prefix' => '/chatbot'], function(){
            Route::post('/chat',[ChatController::class, 'chatConversation'])->name('chat');
            Route::get('/conversation/{id}',[ChatController::class, 'getConversation']);
            Route::post('/createConversation',[ChatController::class, 'createConversation']);
            Route::get('/history/{conversationId}', [ChatController::class, 'getChatHistory']);
            Route::get('/history', [ChatController::class, 'getAllChatHistory']);
            Route::apiResources([
                '/process' => ProcessController::class,
                '/danger' => DangerController::class,
                '/place' => PlaceController::class,
                '/risk' => RiskController::class,
                '/task' => TaskController::class,
                '/work-position' => WorkPositionController::class,
                '/consequence' => ConsequenceController::class,
                '/risk-evaluation' => RiskEvaluationController::class,
                '/iperc' => IPERCController::class,
                '/operational-control' => OperationalControlController::class,
                '/matrix' => MatrixController::class,
            ]);

            Route::get('/matrix/export/pdf/{id}',[MatrixController::class, 'exportarPDF']);
        }); 

    //=============rutas que no necesitan autenticacion==============
    //Solicitud de cotizaciones
    Route::group(['prefix' => '/public'], function(){
        Route::post('/save-queries', [QueryController::class, 'saveQuery']);
        Route::post('/save-queries-manual', [QueryController::class, 'saveQueryManual']);

        Route::get('/banners/list', [BannerController::class, 'getBanners']);
        Route::get('/events/list', [EventController::class, 'getEvents']);
        Route::get('/alerts/get-active', [AlertController::class, 'getActive'])->name('alerts.active');
        Route::get('/listDocumentType', [UsuariosController::class, 'listDocumentType'])->name('document.list');
        Route::get('/listCountry', [UsuariosController::class, 'listCountry'])->name('country.list');
        Route::post('/registerAcademyUser', [UsuariosController::class, 'registerAcademyUser'])->name('registerAcademyUser');
        Route::post('/sendRecoveryEmail', [UsuariosController::class, 'sendRecoveryEmail'])->name('sendRecoveryEmail');
        Route::post('/recoveryPassword', [UsuariosController::class, 'recoveryPassword'])->name('recoveryPassword');
        Route::get('/countries', [CountryController::class, 'index']);
        Route::post('/contactarusuario', [UsuariosController::class, 'contactarusuario'])->name('contactarUsuario');;

        Route::group(['prefix' => '/course'], function(){
            Route::get('/type/{id}', [ProductoController::class, 'getType']);//* no encontrado en aula virtual
            Route::get('/info/{productSlug}/{slug}', [ProductClassController::class, 'searchProductInfo']);
            Route::get('/list', [ProductoController::class, 'list']);
            Route::get('/temary/get-all-class/{slug}', [ProductoController::class, 'show']);
            Route::get('/details/{slug}', [ProductoController::class, 'detailsCourse']);
            Route::get('/{slug}/description', [ProductoController::class, 'getDescription']);

            Route::group(['prefix' => '/class'], function(){
                Route::get('/{slug}/info', [ProductClassController::class, 'classInfo']);
            });
        });

        Route::group(['prefix' => '/news'], function(){
            Route::get('/list', [NewsController::class, 'all']);
            Route::get('/random-list', [NewsController::class, 'random']);
            Route::get('/list/{slug}', [NewsController::class, 'searchBySlug']);
            Route::post('/incrementView', [NewsController::class, 'incrementView']);
        });

        Route::get('/video/get-video-intro/{slug}', [VideoController::class, 'getVideoIntro']);

        //API ISOS
        Route::get('/isos/list', [IsoController::class, 'list'])->name('api.isos.list');
        Route::group(['prefix' => '/sstclient'], function () {
            Route::post('/client-info', [SSTClientController::class, 'getClientInfo']);
            Route::get('/download-certificate', [SSTClientController::class, 'downloadCertificate']);
        });
        // if (config('app.is_api')) {
        Route::group(['prefix' => 'auth', 'namespace' => 'Auth'], function () {
            Route::post('login', [LoginController::class, 'loginApi'])->name('auth.login');
            Route::post('login/redirect', [LoginController::class, 'loginApiForRedirect'])->name('auth.loginRedirect');
            // Route::post('logout', [AuthController::class, 'logout'])->name('auth.logout')->middleware('auth:api');
        });
        Route::group(['prefix' => '/offers'], function(){
            Route::get('/info', [OfferController::class, 'offerInfo']);
        });
        // }

        Route::get('/prueba/exam', [ProductoController::class, 'prueba']);
        Route::get('/prueba2/exam', [ProductoController::class, 'prueba2']);
        Route::get('/prueba3/exam', [ProductoController::class, 'prueba3']);
        Route::get('/prueba4/exam', [ProductoController::class, 'prueba4']);

        Route::get('/matrix/export/excel/{id}',[MatrixController::class, 'exportarExcel']);

    });

    Route::middleware(['auth:api'])->group(function () {
        Route::group(['prefix' => '/course'], function () {
            // Route::get('/test/{id}', [ControllersCourseController::class, 'approved']);
            Route::get('/list-marketplace/{id}', [ProductoController::class, 'listMarketplace']);
            Route::get('/{slug}', [ProductoController::class, 'list']);
            // Route::get('/list/random', [CourseController::class, 'listRandom']);
            Route::get('/temary/get-all-class/{slug}', [ProductoController::class, 'courseContent']);
            // Route::get('/producter/{id}', [CourseController::class, 'listProducer']);

            // Route::get('/recomendations/{category}', [CourseController::class, 'recomendations']);
            // Route::get('/add/lesson/{id}', [CourseController::class, 'addLatestLesson']);
            // Route::get('/show/lesson', [CourseController::class, 'showLatestLesson']);
            // Route::get('/released-courses', [CourseController::class, 'releasedCourses']);
            // Route::get('/last-courses-rep', [CourseController::class, 'lastCoursesReprod']);
            // Route::get('/related-courses', [CourseController::class, 'recommendedCourses']);
            // Route::get('/interesting-courses', [CourseController::class, 'interestingCourses']);
            // Route::get('/purchased-courses', [CourseController::class, 'purchasedCourses']);
            // Route::get('/search-courses/{str}', [CourseController::class, 'searchCourses']);

            // Route::get('/certificate-list', [CertificatesController::class, 'getCertificateUserList']);
            // Route::get('/certificate-discount', [AccountTypeController::class, 'certificateDiscount']);
            // Route::get('/course-discount', [AccountTypeController::class, 'courseDiscount']);


            // Route::get('/rate/show/{id}', [CourseController::class, 'rateCourseShow']);
            // Route::post('/rate/store', [CourseController::class, 'rateCourseStore']);
            // Route::get('/list-actives/producer', [CourseController::class, 'listActiveCourses']);
            // Route::get('/certificate/data', [CourseConfigurationController::class, 'getCertificateConfiguration']);
            Route::group(['prefix' => 'class'], function () {
                // Route::get('/{slug}', [ProductClassController::class, 'classList']);
                Route::get('/get-links/{slug_product}/{slug_class}', [ProductClassController::class, 'getLinks']);
                Route::group(['prefix' => '/resources'], function(){
                    Route::get('/{id}/download', [ClassResourceController::class, 'downloadResources']);
                    Route::get('/{slug}/list', [ClassResourceController::class, 'showResources']);
                });
             Route::group(['prefix' => '/exam'], function () {
                Route::get('/', [ProductoController::class, 'exam']);
                Route::post('/active', [ExamController::class, 'getActiveExam']);
                // Route::post('/module/active', [Exam::class, 'getActiveExamModules']);
                // Route::get('/daily', [DailyQuestion::class, 'get']);
                // Route::post('/daily/points', [DailyQuestion::class, 'validateResponseDaily']);
                Route::post('/answers', [ExamController::class, 'getAnswers']);
                Route::get('/route-back', [ExamController::class, 'routeBack']);
                // Route::get('/isconfig/{id}', [CourseConfigurationController::class, 'checkIfCourseIsConfigurated']);
                Route::get('/list', [ExamController::class, 'examList']);
                Route::get('/course-id', [ProductoController::class, 'courseId']);
                Route::post('/results', [ExamController::class, 'getResults']);
            });
            });

            Route::group(['prefix' => '/exam'], function () {
                Route::get('/', [ProductoController::class, 'exam']);
                Route::post('/active', [ExamController::class, 'getActiveExam']);
                // Route::post('/module/active', [Exam::class, 'getActiveExamModules']);
                // Route::get('/daily', [DailyQuestion::class, 'get']);
                // Route::post('/daily/points', [DailyQuestion::class, 'validateResponseDaily']);
                Route::post('/answers', [ExamController::class, 'getAnswers']);
                Route::get('/route-back', [ExamController::class, 'routeBack']);
                // Route::get('/isconfig/{id}', [CourseConfigurationController::class, 'checkIfCourseIsConfigurated']);
                Route::get('/list', [ExamController::class, 'examList']);
                Route::get('/course-id', [ProductoController::class, 'courseId']);
                Route::post('/results', [ExamController::class, 'getResults']);
            });
        });

        Route::group(['prefix' => 'user'], function () {
            Route::get('/{id}/purchased-products', [ProductoController::class, 'purchasedProducts']);
            Route::get('/{id}/course-slug', [ProductoController::class, 'courseSlug']);
            Route::get('/seller/contact', [UsuariosController::class, 'contactoVendedor']);
            Route::post('/change-pass', [UsuariosController::class, 'changePassword']);
            Route::get('/info', [UsuariosController::class, 'userInfo']);
            Route::post('/update', [UsuariosController::class, 'update']);
            Route::post('/verify-unique-email', [UsuariosController::class, 'verifyUniqueEmail']);
        });

        //Api para video
        Route::group(['prefix' => 'video'], function () {
            // Route::get('/update-status', [VideoController::class, 'updateStatus']);
            Route::get('/stream-video', [VideoController::class, 'streamVideo']);
            // Route::post('/save-time', [VideoController::class, 'saveTime']);
            // Route::get('/show-time', [VideoController::class, 'showTime']);
            // Route::post('/save-video', [VideoController::class, 'saveVideo']);
            // Route::post('/get-video', [VideoController::class, 'getVideo']);
            // Route::post('/delete-video', [VideoController::class, 'deleteVideo']);
            // Route::post('/create-folder', [VideoController::class, 'createFolder']);
            // Route::post('/delete-folder', [VideoController::class, 'deleteFolder']);
        });

        Route::group(['prefix' => '/payments'], function () {
            Route::post('/save-payment', [ProductPaymentController::class, 'savePayment']);
            Route::post('/save-transfer-payment', [ProductPaymentController::class, 'saveTransferPayment']);
        });

        //API PROFESORES
        Route::group(['prefix' => 'profesores'], function () {
            Route::get('/list', [profesoresController::class, 'list'])->name('api.profesores.list');
        });

        Route::group(['prefix' => '/offers'], function(){
            Route::get('/list', [OfferController::class, 'list']);
            Route::get('/details', [OfferController::class, 'offerDetails']);
        });

        Route::group(['prefix' => '/purchased'], function(){
            Route::patch('/save-time', [PurchasedProductController::class, 'saveTimeClass']);
            Route::get('/get-time', [PurchasedProductController::class, 'getTime']);
        });

        Route::group(['prefix' => '/sst-clients'], function(){
            Route::post('/user/get-certificates', [SSTClientController::class, 'getCertificates']);
            Route::post('/user/fechas', [SSTClientController::class, 'getFechas']);
        });
        /*
        Route::group(['prefix' => '/chatbot'], function(){
            Route::post('/chat',[ChatController::class, 'chatConversation'])->name('chat');
            Route::get('/conversation/{id}',[ChatController::class, 'getConversation']);
            Route::post('/createConversation',[ChatController::class, 'createConversation']);
            Route::get('/history/{conversationId}', [ChatController::class, 'getChatHistory']);
            Route::get('/history', [ChatController::class, 'getAllChatHistory']);
            Route::apiResources([
                '/process' => ProcessController::class,
                '/danger' => DangerController::class,
                '/place' => PlaceController::class,
                '/risk' => RiskController::class,
                '/task' => TaskController::class,
                '/work-position' => WorkPositionController::class,
                '/consequence' => ConsequenceController::class,
                '/risk-evaluation' => RiskEvaluationController::class,
                '/iperc' => IPERCController::class,
                '/operational-control' => OperationalControlController::class,
                '/matrix' => MatrixController::class,
            ]);

            Route::get('/matrix/export/pdf/{id}',[MatrixController::class, 'exportarPDF']);
        }); 
        */
    });
});
