<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth; 
use App\Models\User;

class CertificadosPermission
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */
    public function handle(Request $request, Closure $next)
    {
        //obtenemos el id con auth de forma dinamica
        $auth_id = auth::user()->id;
        //separamos el id para las siguientes validaciones
        $user = User::find($auth_id);
        //Permiso para ver certificados 
        $permiso = '3'; 

        if (strlen(strstr($user->permissions, $permiso))>0) {
            return $next($request);
        }else{
            return redirect('/dashboard');
        }

    }
}
