<?php $__env->startSection('title', 'User Membreship - Register'); ?>
<?php $__env->startSection('page-style'); ?>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
<input type="hidden" value="<?php echo e($purchase_number); ?>" id="purchase_number">
<input type="hidden" value="<?php echo e($account_type); ?>" id="account_types">
<input type="hidden" value="<?php echo e($key_openpay); ?>" id="key_openpay">
<input type="hidden" value="<?php echo e($id_openpay); ?>" id="id_openpay">

<div class="row py-5">
    <div class="col-6 col-md-2 d-none d-md-block">
    </div>
    <div class="col-12 col-md-8  mb-2 ">
        <div class="container flex-grow-1 flex-shrink-0">
            <div class="p-3 bg-white shadow-sm rounded-lg">
                <div>
                    <h3 class="d-inline">Crear nueva cuenta</h3>
                    <p class="d-inline float-right">referido por: <b> <?php echo e($sponsor_name); ?> </b></p>
                </div>
                <div id="stepperForm" class="bs-stepper linear">
                    <div class="bs-stepper-header" role="tablist">
                        <div class="step active" data-target="#test-form-1">
                            <button type="button" class="step-trigger" role="tab" id="stepperFormTrigger1" aria-controls="test-form-1" aria-selected="true">
                                <svg style="width:24px;height:24px" viewBox="0 0 24 24">
                                    <path fill="currentColor" d="M12,4A4,4 0 0,1 16,8A4,4 0 0,1 12,12A4,4 0 0,1 8,8A4,4 0 0,1 12,4M12,14C16.42,14 20,15.79 20,18V20H4V18C4,15.79 7.58,14 12,14Z" />
                                </svg>
                                <span class="bs-stepper-label">Cuenta</span>
                            </button>
                        </div>
                        <div class="bs-stepper-line"></div>
                        <div class="step" data-target="#test-form-2">
                            <button type="button" class="step-trigger" role="tab" id="stepperFormTrigger2" aria-controls="test-form-2" aria-selected="false" disabled="disabled">
                                <svg style="width:24px;height:24px" viewBox="0 0 24 24">
                                    <path fill="currentColor" d="M8,9A2,2 0 0,1 10,11A2,2 0 0,1 8,13A2,2 0 0,1 6,11A2,2 0 0,1 8,9M12,17H4V16C4,14.67 6.67,14 8,14C9.33,14 12,14.67 12,16V17M20,8H14V10H20V8M20,12H14V14H20V12M20,16H14V18H20V16M22,4H14V6H22V20H2V6H10V4H2A2,2 0 0,0 0,6V20A2,2 0 0,0 2,22H22A2,2 0 0,0 24,20V6A2,2 0 0,0 22,4M13,6H11V2H13V6Z" />
                                </svg>
                                <span class="bs-stepper-label">Perfil</span>
                            </button>
                        </div>
                        <div class="bs-stepper-line"></div>
                        <div class="step" data-target="#test-form-3">
                            <button type="button" class="step-trigger" role="tab" id="stepperFormTrigger3" aria-controls="test-form-3" aria-selected="false" disabled="disabled">
                                <svg style="width:24px;height:24px" viewBox="0 0 24 24">
                                    <path fill="currentColor" d="M20,10H4V4H20M20,15H4V13H20M20,2H4C2.89,2 2,2.89 2,4V15C2,16.11 2.89,17 4,17H8V22L12,20L16,22V17H20C21.11,17 22,16.11 22,15V4C22,2.89 21.11,2 20,2Z" />
                                </svg>
                                <span class="bs-stepper-label">Membresia</span>
                            </button>
                        </div>
                    </div>
                    <div class="bs-stepper-content">
                        <div>

                            <div id="test-form-1" role="tabpanel" class="bs-stepper-pane fade active dstepper-block" aria-labelledby="stepperFormTrigger1">

                                <div class="row">
                                    <div class="form-group col-12 col-lg-6">
                                        <label for="username"><?php echo e(__('locale.' . 'User')); ?></label>
                                        <input required type="text" id="username" minlength="3" maxlength="50" onkeypress="return checkCharactersSpecial(event)" class="form-control" name="username" value="">
                                        <div id="username_error" class="invalid-feedback"></div>

                                    </div>
                                    <div class="form-group col-12 col-lg-6">
                                        <label for="email"><?php echo e(__('locale.' . 'Email')); ?></label>
                                        <input type="email" id="email" class="form-control" name="email" required value="">
                                        <div id="email_error" class="invalid-feedback"></div>
                                    </div>
                                    <div class="form-group col-12 col-lg-6">
                                        <label for="password"><?php echo e(__('locale.' . 'Password')); ?></label>
                                        <div class="input-group input-group-merge form-password-toggle">
                                            <input required type="password" id="password" class="form-control" name="password" value="">
                                            <span class="input-group-text cursor-pointer" onclick="mostrarContra('password')">
                                                <svg style="width:14px;height:14px" viewBox="0 0 24 24">
                                                    <path fill="currentColor" id="password-icon" d="M12,9A3,3 0 0,1 15,12A3,3 0 0,1 12,15A3,3 0 0,1 9,12A3,3 0 0,1 12,9M12,4.5C17,4.5 21.27,7.61 23,12C21.27,16.39 17,19.5 12,19.5C7,19.5 2.73,16.39 1,12C2.73,7.61 7,4.5 12,4.5M3.18,12C4.83,15.36 8.24,17.5 12,17.5C15.76,17.5 19.17,15.36 20.82,12C19.17,8.64 15.76,6.5 12,6.5C8.24,6.5 4.83,8.64 3.18,12Z" />
                                                </svg>
                                            </span>
                                            <div id="password_error" class="invalid-feedback"></div>
                                        </div>
                                    </div>
                                    <div class="form-group col-12 col-lg-6">
                                        <label for="repassword"><?php echo e(__('locale.' . 'Re-Password')); ?></label>
                                        <div class="input-group input-group-merge form-password-toggle">
                                            <input required type="password" id="repassword" class="form-control" name="password_confirmation" value="">
                                            <span class="input-group-text cursor-pointer" onclick="mostrarContra('repassword')">
                                                <svg style="width:14px;height:14px" viewBox="0 0 24 24">
                                                    <path fill="currentColor" id="repassword-icon" d="M12,9A3,3 0 0,1 15,12A3,3 0 0,1 12,15A3,3 0 0,1 9,12A3,3 0 0,1 12,9M12,4.5C17,4.5 21.27,7.61 23,12C21.27,16.39 17,19.5 12,19.5C7,19.5 2.73,16.39 1,12C2.73,7.61 7,4.5 12,4.5M3.18,12C4.83,15.36 8.24,17.5 12,17.5C15.76,17.5 19.17,15.36 20.82,12C19.17,8.64 15.76,6.5 12,6.5C8.24,6.5 4.83,8.64 3.18,12Z" />
                                                </svg>
                                            </span>
                                            <div id="repassword_error" class="invalid-feedback"></div>
                                        </div>
                                    </div>
                                    <div class="form-group col-12 col-lg-6">
                                        <label for="user_type">Tipo de Usuario</label>
                                        <select id="user_type" class="form-control" name="user_type" onchange="userTypesChanged(<?php echo e($account_type); ?>)">
                                            <option selected hidden><?php echo e(__('locale.' . 'Select_an_option')); ?>

                                            </option>
                                            <?php $__currentLoopData = $user_type; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ut): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($ut->name); ?>"><?php echo e(__('locale.' .$ut->name)); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                        <div id="user_type_error" class="invalid-feedback"></div>
                                    </div>
                                </div>
                                <div class="d-flex justify-content-end">
                                    <div class="btn btn-primary btn-next-form" onclick="next1();">Siguiente <svg style="width:24px;height:24px" viewBox="0 0 24 24">
                                            <path fill="currentColor" d="M8.59,16.58L13.17,12L8.59,7.41L10,6L16,12L10,18L8.59,16.58Z" />
                                        </svg></div>
                                </div>

                            </div>
                            <div id="test-form-2" role="tabpanel" class="bs-stepper-pane fade dstepper-none" aria-labelledby="stepperFormTrigger2">
                                <div class="row">
                                    <div class="form-group col-12 col-lg-6">
                                        <label for="name"><?php echo e(__('locale.' . 'Name')); ?></label>
                                        <input required type="text" id="name" class="form-control" name="name" minlength="2" maxlength="50" onkeypress="return lettersOnly(event)" value="">
                                        <div id="name_error" class="invalid-feedback"></div>
                                    </div>
                                    <div class="form-group col-12 col-lg-6">
                                        <label for="last_name"><?php echo e(__('locale.' . 'Last_Name')); ?></label>
                                        <input required type="text" id="last_name" class="form-control" name="last_name" minlength="3" maxlength="50" onkeypress="return lettersOnly(event)" value="">
                                        <div id="last_name_error" class="invalid-feedback"></div>
                                    </div>
                                    <div class="form-group col-12 col-lg-6">
                                        <label for="biography"><?php echo e(__('locale.' . 'Biography')); ?></label>
                                        <textarea name="biography" id="biography" rows="3" class="form-control"></textarea>
                                        <div id="biography_error" class="invalid-feedback"></div>
                                    </div>
                                    <div class="form-group col-12 col-lg-6">
                                        <label for="phone"><?php echo e(__('locale.' . 'Phones')); ?></label>
                                        <input type="tel" id="phone" oninput="numberOnly(this.id);" placeholder="987654321" required maxlength="15" class="form-control" name="phone" value="">
                                        <div id="phone_error" class="invalid-feedback"></div>
                                    </div>
                                    <div class="form-group col-12 col-lg-6">
                                        <label for="date_birth"><?php echo e(__('locale.' . 'Date_Birth')); ?></label>
                                        <input type="date" id="date_birth" class="form-control" name="date_birth" onchange="validDateBirth();" min="1950-01-01" max="2004-01-01" value="">
                                        <div id="date_birth_error" class="invalid-feedback"></div>
                                    </div>
                                    <div class="form-group col-12 col-lg-6">
                                        <label for="id_document_type"><?php echo e(__('locale.' . 'Document_Type')); ?></label>
                                        <select id="id_document_type" class="form-control" name="id_document_type" onchange="validDocumentType(<?php echo e($document_type); ?>)">
                                            <option value="0" hidden selected>
                                                <?php echo e(__('locale.' . 'Select_an_option')); ?>

                                            </option>
                                            <?php $__currentLoopData = $document_type; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $dt): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($dt->id); ?>"><?php echo e($dt->document); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                        <div id="id_document_type_error" class="invalid-feedback"></div>
                                    </div>
                                    <div class="form-group col-12 col-lg-6">
                                        <label for="nro_document"><?php echo e(__('locale.' . 'Nro._Document')); ?></label>
                                        <input type="text" id="nro_document" oninput="numberOnly(this.id);" class="form-control" name="nro_document" maxlength="15">
                                        <div id="nro_document_error" class="invalid-feedback"></div>
                                    </div>
                                    <div class="form-group col-12 col-lg-6">
                                        <label for="country"><?php echo e(__('locale.' . 'Country')); ?></label>
                                        <select id="country" class="form-control" name="country" onchange="countrySelected(<?php echo e($payment_methods); ?>)">
                                            <option hidden value="0">--------------------</option>
                                            <?php $__currentLoopData = $country; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $c): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($c->id); ?>" <?php echo e($c->name == 'Perú' ? 'selected' : ''); ?>>
                                                <?php echo e($c->name); ?>

                                            </option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                        <div id="country_error" class="invalid-feedback"></div>
                                    </div>
                                </div>
                                <div class="d-flex justify-content-end">
                                    <div class="btn btn-next-form" onclick="previus();"><svg style="width:24px;height:24px" viewBox="0 0 24 24">
                                            <path fill="currentColor" d="M15.41,16.58L10.83,12L15.41,7.41L14,6L8,12L14,18L15.41,16.58Z" />
                                        </svg> Atras</div>

                                    <div class="btn btn-primary btn-next-form" onclick="next2();">Siguiente <svg style="width:24px;height:24px" viewBox="0 0 24 24">
                                            <path fill="currentColor" d="M8.59,16.58L13.17,12L8.59,7.41L10,6L16,12L10,18L8.59,16.58Z" />
                                        </svg></div>
                                </div>

                            </div>
                            <div id="test-form-3" role="tabpanel" class="bs-stepper-pane fade dstepper-none" aria-labelledby="stepperFormTrigger3">
                                <div class="row">
                                    <div class="form-group col-12 col-lg-6">
                                        <label for="id_account_type"><?php echo e(__('locale.' . 'Account_Type')); ?></label>
                                        <select id="id_account_type" class="form-control" name="id_account_type" onchange="accountTypesChanged(<?php echo e($account_type); ?>)">
                                            <option hidden selected value="0">
                                                <?php echo e(__('locale.' . 'Select_an_option')); ?>

                                            </option>
                                            
                                        </select>
                                        <div id="id_account_type_error" class="invalid-feedback"></div>
                                    </div>
                                    <div class="form-group col-12 col-lg-6">
                                        <label for="account_type-price"><?php echo e(__('locale.' . 'Price')); ?></label>
                                        <input type="text" id="account_type-price" class="form-control" disabled>
                                    </div>
                                    <div class="form-group col-12 col-lg-6">
                                        <label for="account_type-iva" data-toggle="tooltip" data-placement="top" title="Impuesto"><?php echo e(__('locale.' . 'IVA')); ?></label>
                                        <input type="text" id="account_type-iva" class="form-control" disabled>
                                    </div>
                                    <div class="form-group col-12 col-lg-6">
                                        <label for="account_type-total_cost_membreship"><?php echo e(__('locale.' . 'Total_cost_of_Membreship')); ?></label>
                                        <input type="text" id="account_type-total_cost_membreship" class="form-control" name="amount" readonly>
                                        <input type="hidden" name="reserved13">
                                    </div>

                                    <div id="payment_method_selector" class="form-group col-12 col-lg-6">
                                        <label for="payment_method_id">Método de Pago</label>
                                        <select id="payment_method_id" name="payment_method_id" class="form-control" onchange="paymentMethodSelected()">
                                            <option hidden selected value="0">
                                                <?php echo e(__('locale.' . 'Select_an_option')); ?>

                                            </option>
                                            <?php $__currentLoopData = $payment_methods; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $c): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($c->id); ?>">
                                                <?php echo e($c->name); ?>

                                            </option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                        <div id="payment_method_id_error" class="invalid-feedback"></div>
                                    </div>

                                    <div class="form-group col-12 col-lg-6"  id="input_operation">
                                        <label for="nro_operation"><?php echo e(__('locale.' . 'Nro._operation')); ?></label>
                                        <input type="text" id="operation_number" oninput="numberOnly(this.id);" class="form-control" name="operation_number">
                                        <div id="operation_number_error" class="invalid-feedback"></div>
                                    </div>

                                    <div class="form-group col-12" id="info_openpay" style="word-break: normal">
                                        Al hacer click en "Pagar", usted está aceptando nuestros <button type="button" class="btn btn-link" data-toggle="modal" data-target="#exampleModal">términos y condiciones.</button>
                                    </div>

                                    <div class="form-group col-12 col-md-6" id="info_operation">
                                        <p>Puede hacer el depósito en la siguiente cuenta:</p>
                                        <p><strong>BCP - En dólares</strong></p>
                                        <p><strong>Nro. de cuenta: </strong>191-8966488-1-93</p>
                                        <p><strong>CCI: </strong>00219100896648819358</p>
                                    </div>

                                    <div class="form-group col-12 col-md-6" id="info_operation2">
                                        <p style="word-break: normal" class="text-success">
                                            Podrá ingresar a la plataforma una vez que uno de nuestros colaboradores haya
                                            verificado el número de operación.
                                        </p>
                                    </div>

                                    <div class="d-flex justify-content-end offset-md-6">
                                        <div class="btn btn-next-form" onclick="previus();"><svg style="width:24px;height:24px" viewBox="0 0 24 24">
                                                <path fill="currentColor" d="M15.41,16.58L10.83,12L15.41,7.41L14,6L8,12L14,18L15.41,16.58Z" />
                                            </svg> Atras</div>

                                        <div id="btnPay" class="btn btn-primary btn-next-form mr-1" onclick="register('<?php echo e(url('/unverified-user/create')); ?>','<?php echo e($id_referrer_sponsor); ?>')">
                                            Pagar <svg style="width:24px;height:24px" viewBox="0 0 24 24">
                                                <path fill="currentColor" d="M20,8H4V6H20M20,18H4V12H20M20,4H4C2.89,4 2,4.89 2,6V18A2,2 0 0,0 4,20H20A2,2 0 0,0 22,18V6C22,4.89 21.1,4 20,4Z" />
                                            </svg>
                                        </div>
                                        <div id="btnFree" class="btn btn-primary btn-next-form mr-1" onclick="register('<?php echo e(url('/users/create-free')); ?>','<?php echo e($id_referrer_sponsor); ?>')">
                                            Registrarme gratis <svg style="width:24px;height:24px" viewBox="0 0 24 24">
                                                <path fill="currentColor" d="M20,8H4V6H20M20,18H4V12H20M20,4H4C2.89,4 2,4.89 2,6V18A2,2 0 0,0 4,20H20A2,2 0 0,0 22,18V6C22,4.89 21.1,4 20,4Z" />
                                            </svg>
                                        </div>
                                        <div id="btnUnverified" class="btn btn-primary btn-next-form mr-1" onclick="register('<?php echo e(url('users/create-unverified-user')); ?>','<?php echo e($id_referrer_sponsor); ?>')">
                                            Registrar <svg style="width:24px;height:24px" viewBox="0 0 24 24">
                                                <path fill="currentColor" d="M20,8H4V6H20M20,18H4V12H20M20,4H4C2.89,4 2,4.89 2,6V18A2,2 0 0,0 4,20H20A2,2 0 0,0 22,18V6C22,4.89 21.1,4 20,4Z" />
                                            </svg>
                                        </div>

                                        <div id="niubiz_container">
                                            <?php echo csrf_field(); ?>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-12 col-md-2 d-none d-md-block"></div>
    </div>
</div>
</div>
<div class="modal fade" id="exampleModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title" id="exampleModalLabel">Términos y condiciones</h5>
          <button type="button" class="close" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true">&times;</span>
          </button>
        </div>
        <div class="modal-body">
            <?php echo $__env->make('modalOpenpayConditions', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        </div>
        <div class="modal-footer">
          <button type="button" class="btn btn-primary" data-dismiss="modal">Cerrar</button>
        </div>
      </div>
    </div>
</div>

<style>
    body {
        background-image: url('https://img.freepik.com/foto-gratis/fondo-textura-ruido-digital-efecto-falla-negra_53876-103977.jpg?t=st=1655316480~exp=1655317080~hmac=34afa60ad6e9d0227fd7f478c0c6a1201745ce8a9a3dc6dcc9c76f5844588a39&w=900');
        background-size: cover;
        background-repeat: repeat-y;
    }

    .row {
        margin-right: 0 !important;
        margin-left: 0 !important;
    }
</style>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('page-script'); ?>
<script src="<?php echo e(asset('js/api/users-register.js')); ?>"></script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts/registerLayout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/promolider/public_html/crm/resources/views/content/user-membreship/register.blade.php ENDPATH**/ ?>