require("@nomiclabs/hardhat-waffle");
require("@nomiclabs/hardhat-ethers");
require("dotenv").config();
const fs = require('fs');
const { url } = require("inspector");

task("accounts", "Prints the list of accounts", async (taskArgs, hre) => {
  const accounts = await hre.ethers.getSigners();
  for (const account of accounts) {
    console.log(account.address);
  }
});

module.exports = {
  defaultNetwork: "hardhat",
  networks: {
    Ganache: {
      url: process.env.REACT_APP_PROVIDER_URL,
      chainId: 1337,
      accounts: [process.env.REACT_APP_PRIVATE_KEY]
    },
    blockchain:{
      url:process.env.REACT_APP_PROVIDER_URL,
      accounts:[process.env.REACT_APP_PRIVATE_KEY]
    }
  },
  solidity: {
    version: "0.8.4",
    settings: {
      optimizer: {
        enabled: true,
        runs: 200
      }
    }
  }
};
