import { useEffect, useState } from "react";
import axios from "axios";
import { ethers } from "ethers";
import MarketplaceJSON from "../../Promolider.json";
import { CollectCard } from "./Cards";

export function Collections() {
    const [data, updateData] = useState([]);
    const [filter,setFilter]=useState("all")
    const [loading,setLoading]=useState(true)
    const [ischange,toggleChange]=useState(true)
    
    const getAllNFTsbyCollection=async(e)=>{
        setLoading(true)
        setFilter(e.target.value)
            const nameCollection=e.target.value    

            const provider = new ethers.providers.JsonRpcProvider(process.env.REACT_APP_PROVIDER_URL);
            const contract = new ethers.Contract(MarketplaceJSON.address, MarketplaceJSON.abi, provider)
            const nfts = await contract.getNFTsByCollection(nameCollection)

            const items = await Promise.allSettled(nfts.map(async nft => {
                const tokenURI = await contract.tokenURI(nft.tokenId);
                let meta = await axios.get(tokenURI);
                meta = meta.data;
                
                const price = ethers.utils.formatUnits(nft.price.toString(), 'ether');
                
                const item = {
                    price,
                    tokenId: nft.tokenId.toNumber(),
                    seller: nft.seller,
                    owner: nft.owner,
                    image: meta.image,
                    name: meta.name,
                    description: meta.description,
                }
                return item;
            }))
            setLoading(false)
            updateData(items)
    }

    useEffect(()=>{
        setLoading(true)
        async function getAllNFTs() {   
                const provider = new ethers.providers.JsonRpcProvider(process.env.REACT_APP_PROVIDER_URL);

                const contract = new ethers.Contract(MarketplaceJSON.address, MarketplaceJSON.abi, provider)

                const nfts = await contract.getAllNFTs()
                const items = await Promise.allSettled(nfts.map(async nft => {
                    const tokenURI = await contract.tokenURI(nft.tokenId);
                    let meta = await axios.get(tokenURI);
                    meta = meta.data;
                    
                    const price = ethers.utils.formatUnits(nft.price.toString(), 'ether');
                    
                    const item = {
                        price,
                        tokenId: nft.tokenId.toNumber(),
                        seller: nft.seller,
                        owner: nft.owner,
                        image: meta.image,
                        name: meta.name,
                        description: meta.description,
                    }
                    return item;
                }))
                setLoading(false)
                return updateData(items)
        }   
        
        getAllNFTs();
    },[ischange])
    

    return (
        <section className="collections pt-40" id="collections">
                <div className="container">
                    <h1 className="bold md:size6 size5 ta-center titlegreen">Colecciones</h1>
                    <p className="spacebottom3 halfwhite size2 ta-center">
                        Visualiza nuestra gran colección de NFT<br />que tenemos para ti
                    </p>
                    <div className="row spacebottom3 filter-buttons justify-between">
                        <button onClick={()=>{toggleChange(prev=>!prev);setFilter("all")}} className={`${filter==="all"?"text-green-600":""} col3 filter col6-xs spacebottom1-xs`} data-filter="all" value={"all"}>Todo</button>
                        <button onClick={getAllNFTsbyCollection} className={`${filter==="0"?"text-green-600":""} col3 filter col6-xs spacebottom1-xs`} data-filter="art" value={"0"}>1° Edicion</button>
                        <button onClick={getAllNFTsbyCollection} className={`${filter==="1"?"text-green-600":""} col3 filter col6-xs`} data-filter="photograpy" value={"1"}>2° Edicion</button>
                        <button onClick={getAllNFTsbyCollection} className={`${filter==="2"?"text-green-600":""} col3 filter col6-xs`} data-filter="pattern" value={"2"}>3° Edicion</button>
                    </div>
                    <CollectCard data={data} loading={loading}/>
                </div>
            </section>
    )
}