import { useEffect, useState } from "react";
import { ProfilePageSell } from "./ProfilePageSell";
import axios from "axios";
import { Navigate, useParams } from "react-router-dom";
import { useAddress } from "../../Context/Account";
import MarketplaceJSON from "../../Promolider.json";
import { ethers } from "ethers";

export function ProtecPage() {
    
    const [data,updateData]=useState([])
    const [loading,setLoading]=useState(true)
    const {address}=useAddress()
    const params = useParams();
    const tokenId=params?.tokenId

    useEffect(()=>{

        async function nft() {
            try {
                
                const provider= new ethers.providers.Web3Provider(window.ethereum)
                const signer=provider.getSigner()
                const contract= new ethers.Contract(MarketplaceJSON.address,MarketplaceJSON.abi,signer)
                
                const tokenURI = await contract.tokenURI(tokenId);
                
                const listedToken = await contract.getListedTokenForId(tokenId);
                
                const listPrice=await contract.getListPrice()
                const comision = ethers.utils.formatUnits(listPrice.toString(), 'ether');
                
                let meta = await axios.get(tokenURI);
                meta = meta.data;
                const price=ethers.utils.formatUnits(listedToken.price.toString(),'ether')
                
                const item = {
                    price,
                    tokenId: listedToken.tokenId.toString(),
                    seller: listedToken.seller,
                    owner: listedToken.owner,
                    listed:listedToken.currentlyListed,
                    image: meta.image,
                    name: meta.name,
                    description: meta.description,
                    comision,
                    collection:listedToken.collection,
                    terminos:meta.terminos
                };
                
                updateData(item);
            } catch (error) {
                updateData({owner:undefined})
            }finally{
                setLoading(false)
            }
        }
        nft()

      },[])

      if (loading) return <div className="min-h-[900px] mt-40 grid place-content-center text-3xl">Loading...</div>

    return data?.owner==address?<ProfilePageSell data={data}/>:<Navigate to={`/nftPage/${tokenId}`} />
          
}