import { useEffect, useState } from "react";
import { Navigate } from "react-router-dom"; 
import { onAuthStateChanged } from "firebase/auth";
import { auth } from "../../firebase/firebaseCredentials";

export function ProtectedRoute({ children }) {

  const [user, setUser] = useState(null);
  const [loading, setLoading] = useState(true); 

  useEffect(() => {
    const unsubscribe = onAuthStateChanged(auth, (userLoged) => {
      setUser(userLoged);
      setLoading(false); 
    });

    return () => unsubscribe();
  }, []);

  if (loading) return <div>Loading...</div>; 
  

  return user ? children : <Navigate to="/signin" />;
}
